/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.api.storage.recipe;

import java.util.List;
import net.flytre.flytre_lib.api.base.util.TagUtils;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public final class TaggedItem {
    private final ResourceLocation path;
    private final int qty;

    public TaggedItem(ResourceLocation path) {
        this(path, 1);
    }

    public TaggedItem(ResourceLocation path, int qty) {
        this.path = path;
        this.qty = qty;
    }

    public Item getItem() {
        List values = TagUtils.getKeyValuesAsList(Registry.f_122827_, TagKey.m_203882_((ResourceKey)Registry.f_122827_.m_123023_(), (ResourceLocation)this.path));
        return values.size() >= 1 ? (Item)values.get(0) : Items.f_41852_;
    }

    public ItemStack getItemStack() {
        return new ItemStack((ItemLike)this.getItem(), this.qty);
    }

    public int getQty() {
        return this.qty;
    }

    public ResourceLocation getPath() {
        return this.path;
    }

    public String toString() {
        return "TaggedItem{path=" + this.path + ", qty=" + this.qty + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaggedItem that = (TaggedItem)o;
        if (this.qty != that.qty) {
            return false;
        }
        return this.path.equals((Object)that.path);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + this.qty;
        return result;
    }
}

