/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.impl.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class PacketUtilsImpl {
    public static final Map<ResourceLocation, PacketData> REGISTERED_IDS = new HashMap<ResourceLocation, PacketData>();
    public static final Map<Class<?>, PacketData> REGISTERED_TYPES = new HashMap();
    public static final List<Triad<? extends Packet<ServerGamePacketListener>>> PLAY_C2S_PACKET = new ArrayList<Triad<? extends Packet<ServerGamePacketListener>>>();
    public static final List<Triad<? extends Packet<ClientGamePacketListener>>> PLAY_S2C_PACKET = new ArrayList<Triad<? extends Packet<ClientGamePacketListener>>>();

    private PacketUtilsImpl() {
    }

    private static ResourceLocation toId(Class<?> type) {
        return new ResourceLocation("flytre_lib", type.getName().toLowerCase().replaceAll("[^a-zA-Z0-9_/.-]", "_"));
    }

    public static <P extends Packet<ClientGamePacketListener>> void registerS2CPacket(Class<P> type, Function<FriendlyByteBuf, P> function) {
        ResourceLocation id = PacketUtilsImpl.toId(type);
        PLAY_S2C_PACKET.add(new Triad<P>(type, function, PacketUtilsImpl.toId(type)));
        PacketData data = new PacketData(true, PLAY_S2C_PACKET.size() - 1);
        REGISTERED_IDS.put(id, data);
        REGISTERED_TYPES.put(type, data);
    }

    public static <P extends Packet<ServerGamePacketListener>> void registerC2SPacket(Class<P> type, Function<FriendlyByteBuf, P> function) {
        ResourceLocation id = PacketUtilsImpl.toId(type);
        PLAY_C2S_PACKET.add(new Triad<P>(type, function, PacketUtilsImpl.toId(type)));
        PacketData data = new PacketData(false, PLAY_C2S_PACKET.size() - 1);
        REGISTERED_IDS.put(id, data);
        REGISTERED_TYPES.put(type, data);
    }

    public static <T> void toPacket(FriendlyByteBuf buf, List<T> list, BiConsumer<T, FriendlyByteBuf> func) {
        buf.writeInt(list.size());
        for (T element : list) {
            func.accept(element, buf);
        }
    }

    public static <T> void toPacket(FriendlyByteBuf buf, Set<T> set, BiConsumer<T, FriendlyByteBuf> func) {
        buf.writeInt(set.size());
        for (T element : set) {
            func.accept(element, buf);
        }
    }

    public static <T, K> void toPacket(FriendlyByteBuf buf, Map<T, K> map, BiConsumer<T, FriendlyByteBuf> keyToPacket, BiConsumer<K, FriendlyByteBuf> valToPacket) {
        buf.writeInt(map.keySet().size());
        for (T key : map.keySet()) {
            keyToPacket.accept(key, buf);
            valToPacket.accept(map.get(key), buf);
        }
    }

    public static <T> List<T> listFromPacket(FriendlyByteBuf buf, Function<FriendlyByteBuf, T> func) {
        int size = buf.readInt();
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            result.add(func.apply(buf));
        }
        return result;
    }

    public static <T> Set<T> setFromPacket(FriendlyByteBuf buf, Function<FriendlyByteBuf, T> func) {
        int size = buf.readInt();
        HashSet<T> result = new HashSet<T>();
        for (int i = 0; i < size; ++i) {
            result.add(func.apply(buf));
        }
        return result;
    }

    public static <T, K> Map<T, K> mapFromPacket(FriendlyByteBuf buf, Function<FriendlyByteBuf, T> packetToKey, Function<FriendlyByteBuf, K> packetToVal) {
        HashMap<T, K> result = new HashMap<T, K>();
        int hashSize = buf.readInt();
        for (int i = 0; i < hashSize; ++i) {
            T key = packetToKey.apply(buf);
            K value = packetToVal.apply(buf);
            result.put(key, value);
        }
        return result;
    }

    public record Triad<P>(Class<P> type, Function<FriendlyByteBuf, P> creator, ResourceLocation channel) {
    }

    public record PacketData(boolean clientbound, int index) {
    }
}

