/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.impl.base;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class RenderUtilsImpl {
    private static FluidRenderer renderer = (matrixStack, fluid, drawHeight, x, y, width, height) -> {
        throw new AssertionError((Object)"Fabric API is required to use this method");
    };
    private static SpriteGetter spriteGetter = (world, pos, fluid) -> {
        throw new AssertionError((Object)"Fabric API is required to use this method");
    };
    private static ColorGetter colorGetter = (world, pos, fluid) -> {
        throw new AssertionError((Object)"Fabric API is required to use this method");
    };
    private static boolean renderingSupported = false;

    private RenderUtilsImpl() {
    }

    public static boolean isFluidRenderingSupported() {
        return renderingSupported;
    }

    static void setSpriteGetter(SpriteGetter spriteGetter) {
        RenderUtilsImpl.spriteGetter = spriteGetter;
    }

    static void setColorGetter(ColorGetter colorGetter) {
        RenderUtilsImpl.colorGetter = colorGetter;
    }

    static void setRenderer(FluidRenderer renderer) {
        RenderUtilsImpl.renderer = renderer;
        renderingSupported = true;
    }

    public static TextureAtlasSprite getSprite(Level world, BlockPos pos, Fluid fluid) {
        return spriteGetter.get(world, pos, fluid);
    }

    public static int getColor(Level world, BlockPos pos, Fluid fluid) {
        return colorGetter.get(world, pos, fluid);
    }

    public static void renderFluidInGui(PoseStack matrixStack, Fluid fluid, int drawHeight, int x, int y, int width, int height) {
        renderer.render(matrixStack, fluid, drawHeight, x, y, width, height);
    }

    @FunctionalInterface
    static interface SpriteGetter {
        public TextureAtlasSprite get(Level var1, BlockPos var2, Fluid var3);
    }

    @FunctionalInterface
    static interface ColorGetter {
        public int get(Level var1, BlockPos var2, Fluid var3);
    }

    @FunctionalInterface
    static interface FluidRenderer {
        public void render(PoseStack var1, Fluid var2, int var3, int var4, int var5, int var6, int var7);
    }
}

