/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.impl.config;

import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import net.flytre.flytre_lib.api.base.util.Formatter;
import net.flytre.flytre_lib.api.base.util.reflection.FieldMatch;
import net.flytre.flytre_lib.api.config.ConfigHandler;
import net.flytre.flytre_lib.api.config.annotation.Description;
import net.flytre.flytre_lib.api.config.annotation.DisplayName;
import net.flytre.flytre_lib.api.config.annotation.Range;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ConfigHelper {
    private ConfigHelper() {
    }

    public static String asString(Range range) {
        return "[min: " + Formatter.formatNumber(range.min()) + ", max: " + Formatter.formatNumber(range.max()) + "]";
    }

    public static String getEnumName(Enum<?> val, boolean useDisplayName) {
        Field field;
        try {
            field = val.getClass().getField(val.name());
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)("Enum value " + val + " was remapped. Tell the developer to modify obfuscation settings."));
        }
        DisplayName display = field.getAnnotation(DisplayName.class);
        if (display != null && useDisplayName) {
            return display.translationKey() ? I18n.m_118938_((String)display.value(), (Object[])new Object[0]) : display.value();
        }
        SerializedName serializedName = field.getAnnotation(SerializedName.class);
        if (serializedName != null) {
            return serializedName.value();
        }
        return val.name();
    }

    public static String getName(ConfigHandler<?> handler, FieldMatch fieldMatch) {
        DisplayName display = fieldMatch.field().getAnnotation(DisplayName.class);
        if (display != null) {
            return display.translationKey() ? I18n.m_118938_((String)display.value(), (Object[])new Object[0]) : display.value();
        }
        if (handler.getTranslationPrefix() != null && I18n.m_118936_((String)(handler.getTranslationPrefix() + "." + fieldMatch.serializedName()))) {
            return I18n.m_118938_((String)(handler.getTranslationPrefix() + "." + fieldMatch.serializedName()), (Object[])new Object[0]);
        }
        String base = fieldMatch.serializedName() != null ? fieldMatch.serializedName() : fieldMatch.field().getName();
        base = base.replaceAll("_", " ");
        return WordUtils.capitalize((String)base);
    }

    public static String enumAsStringArray(Class<?> type) {
        assert (type.isEnum());
        Enum[] objs = (Enum[])type.getEnumConstants();
        if (objs == null) {
            return "[Error: could not get possible values]";
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Enum val : objs) {
            result.add(ConfigHelper.getEnumName(val, false));
        }
        return ((Object)result).toString();
    }

    public static String getDescription(FieldMatch match) {
        Description descriptionAnnotation = match.field().getAnnotation(Description.class);
        return descriptionAnnotation == null ? "" : descriptionAnnotation.value();
    }

    public static int getWidth() {
        return Minecraft.m_91087_().m_91268_().m_85445_();
    }

    public static Object convertDouble(Class<?> fieldClass, double value) {
        if (Integer.class.isAssignableFrom(fieldClass) || Integer.TYPE.isAssignableFrom(fieldClass)) {
            return (int)value;
        }
        if (Double.class.isAssignableFrom(fieldClass) || Double.TYPE.isAssignableFrom(fieldClass)) {
            return value;
        }
        if (Long.class.isAssignableFrom(fieldClass) || Long.TYPE.isAssignableFrom(fieldClass)) {
            return (long)value;
        }
        if (Byte.class.isAssignableFrom(fieldClass) || Byte.TYPE.isAssignableFrom(fieldClass)) {
            return (byte)value;
        }
        if (Short.class.isAssignableFrom(fieldClass) || Short.TYPE.isAssignableFrom(fieldClass)) {
            return (short)value;
        }
        if (Float.class.isAssignableFrom(fieldClass) || Float.TYPE.isAssignableFrom(fieldClass)) {
            return Float.valueOf((float)value);
        }
        if (BigInteger.class.isAssignableFrom(fieldClass)) {
            return BigDecimal.valueOf(value).toBigInteger();
        }
        if (BigDecimal.class.isAssignableFrom(fieldClass)) {
            return BigDecimal.valueOf(value);
        }
        throw new IllegalArgumentException("Unknown class:" + fieldClass);
    }
}

