/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.impl.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.flytre.flytre_lib.api.config.ConfigHandler;
import net.flytre.flytre_lib.api.config.network.SyncedConfig;
import net.flytre.flytre_lib.impl.config.ConfigS2CPacket;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.players.PlayerList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ConfigRegistryImpl {
    private static final List<ConfigHandler<?>> SERVER_CONFIGS = new ArrayList();
    private static final List<ConfigHandler<?>> CLIENT_CONFIGS = new ArrayList();

    private ConfigRegistryImpl() {
    }

    public static void registerClientConfig(ConfigHandler<?> handler) {
        CLIENT_CONFIGS.add(handler);
    }

    public static void registerServerConfig(ConfigHandler<?> handler) {
        SERVER_CONFIGS.add(handler);
    }

    public static int reloadServerConfigs(@Nullable PlayerList manager) {
        for (ConfigHandler<?> configHandler : SERVER_CONFIGS) {
            configHandler.handle();
        }
        if (manager != null) {
            ConfigRegistryImpl.getServerConfigs().forEach(i -> {
                if (i.getConfig() instanceof SyncedConfig) {
                    manager.m_11314_().forEach(player -> player.f_8906_.m_141995_((Packet)new ConfigS2CPacket((ConfigHandler<?>)i)));
                }
            });
        }
        return SERVER_CONFIGS.size();
    }

    public static int reloadClientConfigs() {
        for (ConfigHandler<?> configHandler : CLIENT_CONFIGS) {
            configHandler.handle();
        }
        return CLIENT_CONFIGS.size();
    }

    public static List<ConfigHandler<?>> getServerConfigs() {
        return Collections.unmodifiableList(SERVER_CONFIGS);
    }

    public static List<ConfigHandler<?>> getClientConfigs() {
        return Collections.unmodifiableList(CLIENT_CONFIGS);
    }
}

