/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.impl.config;

import com.google.gson.JsonElement;
import java.util.Optional;
import net.flytre.flytre_lib.api.base.util.JsonNbtConverter;
import net.flytre.flytre_lib.api.config.ConfigHandler;
import net.flytre.flytre_lib.impl.config.ConfigRegistryImpl;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ConfigS2CPacket
implements Packet<ClientGamePacketListener> {
    private final ConfigHandler<?> handler;
    private final CompoundTag nbt;

    public ConfigS2CPacket(ConfigHandler<?> handler) {
        this.handler = handler;
        this.nbt = (CompoundTag)JsonNbtConverter.toNbt(handler.getConfigAsJson());
    }

    public ConfigS2CPacket(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        Optional<ConfigHandler> optional = ConfigRegistryImpl.getServerConfigs().stream().filter(i -> i.getConfigId().equals((Object)id)).findFirst();
        if (optional.isEmpty()) {
            throw new AssertionError((Object)("Config " + id + " not registered on client."));
        }
        this.handler = optional.get();
        this.nbt = buf.m_130260_();
    }

    public void m_5779_(FriendlyByteBuf buf) {
        buf.m_130085_(this.handler.getConfigId());
        buf.m_130079_(this.nbt);
    }

    public void apply(ClientGamePacketListener listener) {
        JsonElement json = JsonNbtConverter.toJson((Tag)this.nbt);
        this.handler.setConfig(json);
    }
}

