/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.impl.config.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.flytre.flytre_lib.api.config.ConfigHandler;
import net.flytre.flytre_lib.api.config.annotation.DisplayName;
import net.flytre.flytre_lib.api.gui.button.TranslucentButton;
import net.flytre.flytre_lib.impl.config.ConfigRegistryImpl;
import net.flytre.flytre_lib.impl.config.client.GenericConfigScreen;
import net.flytre.flytre_lib.impl.config.client.GuiMaker;
import net.flytre.flytre_lib.impl.config.client.StringValueWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ConfigListerScreen
extends GenericConfigScreen {
    private StringValueWidget<AbstractWidget> list;

    public ConfigListerScreen(@Nullable Screen parent) {
        super(parent, null);
    }

    public static String getName(DisplayName display, String baseName) {
        if (display != null) {
            return display.translationKey() ? I18n.m_118938_((String)display.value(), (Object[])new Object[0]) : display.value();
        }
        String base = baseName.replaceAll("_", " ");
        return WordUtils.capitalize((String)base);
    }

    public void populate() {
        List handlers = Stream.of(ConfigRegistryImpl.getClientConfigs(), ConfigRegistryImpl.getServerConfigs()).flatMap(Collection::stream).toList();
        for (ConfigHandler handler : handlers) {
            TranslucentButton button = new TranslucentButton(0, 0, Math.min(250, this.f_96543_), 20, (Component)new TranslatableComponent("flytre_lib.gui.open"), but -> Minecraft.m_91087_().m_91152_(GuiMaker.createGui(this, but, handler)));
            this.list.addEntry(ConfigListerScreen.getName(handler.getAssumed().getClass().getAnnotation(DisplayName.class), handler.getName()), (AbstractWidget)button);
        }
    }

    @Override
    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6305_(matrices, mouseX, mouseY, delta);
        ConfigListerScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)new TranslatableComponent("flytre_lib.gui.client_message"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ - 60), (int)-1);
    }

    public StringValueWidget<AbstractWidget> getList() {
        return this.list;
    }

    protected void m_7856_() {
        this.list = new StringValueWidget(this.f_96541_, this.f_96543_, this.f_96544_, 60, this.f_96544_ - 60, 30);
        this.populate();
        this.m_142416_((GuiEventListener)this.list);
    }
}

