/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.impl.config.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.flytre.flytre_lib.api.base.util.reflection.FieldMatch;
import net.flytre.flytre_lib.api.base.util.reflection.ReflectionUtils;
import net.flytre.flytre_lib.api.config.ConfigColor;
import net.flytre.flytre_lib.api.config.ConfigHandler;
import net.flytre.flytre_lib.api.config.GsonHelper;
import net.flytre.flytre_lib.api.config.annotation.Populator;
import net.flytre.flytre_lib.api.config.annotation.Range;
import net.flytre.flytre_lib.api.config.reference.Reference;
import net.flytre.flytre_lib.api.config.reference.block.ConfigBlock;
import net.flytre.flytre_lib.api.config.reference.entity.ConfigEntity;
import net.flytre.flytre_lib.api.config.reference.fluid.ConfigFluid;
import net.flytre.flytre_lib.api.config.reference.item.ConfigItem;
import net.flytre.flytre_lib.api.gui.TranslucentSliderWidget;
import net.flytre.flytre_lib.api.gui.button.TranslucentButton;
import net.flytre.flytre_lib.api.gui.button.TranslucentCyclingOption;
import net.flytre.flytre_lib.api.gui.text_field.ColorWidget;
import net.flytre.flytre_lib.api.gui.text_field.DropdownMenu;
import net.flytre.flytre_lib.api.gui.text_field.DropdownUtils;
import net.flytre.flytre_lib.api.gui.text_field.NumberBox;
import net.flytre.flytre_lib.api.gui.text_field.TranslucentTextField;
import net.flytre.flytre_lib.impl.config.ConfigHelper;
import net.flytre.flytre_lib.impl.config.client.AsynchronousDropdownMenu;
import net.flytre.flytre_lib.impl.config.client.ConfigError;
import net.flytre.flytre_lib.impl.config.client.ConfigListWidget;
import net.flytre.flytre_lib.impl.config.client.IndividualConfigScreen;
import net.flytre.flytre_lib.impl.config.client.ListEditorScreen;
import net.flytre.flytre_lib.impl.config.client.MapEditorScreen;
import net.flytre.flytre_lib.impl.config.client.ObjectWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class GuiMaker {
    private static final Predicate<Class<?>> IS_ITEM = i -> ConfigItem.class.isAssignableFrom((Class<?>)i) || Item.class.isAssignableFrom((Class<?>)i);
    private static final Predicate<Class<?>> IS_BLOCK = i -> ConfigBlock.class.isAssignableFrom((Class<?>)i) || Block.class.isAssignableFrom((Class<?>)i);
    private static final Predicate<Class<?>> IS_ENTITY = i -> ConfigEntity.class.isAssignableFrom((Class<?>)i) || EntityType.class.isAssignableFrom((Class<?>)i);
    private static final Predicate<Class<?>> IS_FLUID = i -> ConfigFluid.class.isAssignableFrom((Class<?>)i) || Fluid.class.isAssignableFrom((Class<?>)i);
    private static final Predicate<Class<?>> IS_IDENTIFIER = i -> Reference.class.isAssignableFrom((Class<?>)i) || GsonHelper.REGISTRY_BASED.keySet().stream().anyMatch(clazz -> clazz.isAssignableFrom((Class<?>)i));

    private GuiMaker() {
    }

    public static <K> Screen createGui(Screen parent, @Nullable Button reopen, ConfigHandler<K> handler) {
        if (!handler.handle()) {
            return null;
        }
        IndividualConfigScreen<K> screen = new IndividualConfigScreen<K>(parent, reopen, handler);
        JsonElement element = handler.getConfigAsJson();
        if (!(element instanceof JsonObject)) {
            throw new AssertionError((Object)"Non-object config cannot be parsed");
        }
        JsonElement defaultElement = handler.getGson().toJsonTree(handler.getAssumed());
        assert (defaultElement instanceof JsonObject);
        GuiMaker.createGuiHelper(new ParentData<K>(screen, handler, handler.getConfig().getClass(), (JsonObject)element, handler.getConfig(), (JsonObject)defaultElement, handler.getAssumed()));
        return screen;
    }

    private static <K> void createGuiHelper(ParentData<K> state) {
        try {
            List<Field> fields = ReflectionUtils.getFields(state.clazz);
            for (Map.Entry entry : state.json.entrySet()) {
                FieldMatch fieldMatch = ReflectionUtils.match(fields, (String)entry.getKey());
                if (fieldMatch == null) continue;
                GuiMaker.addGuiElement(state, fieldMatch, entry, state.defJson.get((String)entry.getKey()));
            }
        }
        catch (IllegalAccessException e) {
            throw new ConfigError((Object)e);
        }
    }

    private static <K> void addGuiElement(ParentData<K> state, FieldMatch fieldMatch, Map.Entry<String, JsonElement> entry, JsonElement defaultValue) throws IllegalAccessException {
        String name = ConfigHelper.getName(state.handler, fieldMatch);
        String description = ConfigHelper.getDescription(fieldMatch);
        fieldMatch.field().setAccessible(true);
        Object value = GuiMaker.getValue(fieldMatch, state.obj);
        Class<?> temp = fieldMatch.field().getType();
        if (temp == Object.class) {
            temp = value.getClass();
        }
        Class<?> fieldClass = temp;
        if (value instanceof Number || Number.class.isAssignableFrom(fieldClass)) {
            GuiMaker.addNumber(state, name, description, fieldMatch, fieldClass);
        } else if (IS_ITEM.test(value.getClass())) {
            GuiMaker.addString(DropdownUtils.createItemDropdown(), state, fieldMatch, entry.getValue(), name, description);
        } else if (IS_FLUID.test(value.getClass())) {
            GuiMaker.addString(DropdownUtils.createFluidDropdown(), state, fieldMatch, entry.getValue(), name, description);
        } else if (IS_BLOCK.test(value.getClass())) {
            GuiMaker.addString(DropdownUtils.createBlockDropdown(), state, fieldMatch, entry.getValue(), name, description);
        } else if (IS_ENTITY.test(value.getClass())) {
            GuiMaker.addString(AsynchronousDropdownMenu.createEntityDropdown(), state, fieldMatch, entry.getValue(), name, description);
        } else if (IS_IDENTIFIER.test(value.getClass())) {
            TranslucentTextField searchField = new TranslucentTextField(0, 0, GuiMaker.width(), 20, Component.m_130674_((String)""));
            searchField.setRenderer(DropdownUtils::identifierTextFieldRenderer);
            GuiMaker.addString(searchField, state, fieldMatch, entry.getValue(), name, description);
        } else if (value instanceof Boolean || Boolean.class.isAssignableFrom(fieldClass) || fieldClass == Boolean.TYPE) {
            GuiMaker.addBoolean(state, fieldMatch, name, description);
        } else if (value instanceof ConfigColor || ConfigColor.class.isAssignableFrom(fieldClass)) {
            ColorWidget colorWidget = new ColorWidget(0, 0, GuiMaker.width(), 20, Component.m_130674_((String)""));
            GuiMaker.addString(colorWidget, state, fieldMatch, entry.getValue(), name, description);
        } else if (value instanceof Enum || Enum.class.isAssignableFrom(fieldClass)) {
            GuiMaker.addEnum(state, fieldClass, fieldMatch, entry.getValue(), name, description);
        } else if (entry.getValue().isJsonArray()) {
            GuiMaker.addList(state, fieldMatch, name, description);
        } else if (Map.class.isAssignableFrom(fieldClass)) {
            GuiMaker.addMap(state, fieldMatch, name, description);
        } else if (entry.getValue().isJsonObject()) {
            JsonObject entryValue = (JsonObject)entry.getValue();
            TranslucentButton button = new TranslucentButton(0, 0, GuiMaker.width(), 20, (Component)new TranslatableComponent("flytre_lib.gui.open"), but -> {
                IndividualConfigScreen innerScreen = new IndividualConfigScreen(state.screen, null, state.handler);
                GuiMaker.createGuiHelper(new ParentData(innerScreen, state.handler, fieldClass, entryValue, GuiMaker.getValue(fieldMatch, state.obj), (JsonObject)defaultValue, GuiMaker.getValue(fieldMatch, state.defObj)));
                Minecraft.m_91087_().m_91152_(innerScreen);
            });
            state.screen.addEntry(new ConfigListWidget.ConfigEntry((AbstractWidget)button, name, description));
        } else {
            TranslucentTextField textField = new TranslucentTextField(0, 0, GuiMaker.width(), 20, Component.m_130674_((String)""));
            GuiMaker.addString(textField, state, fieldMatch, entry.getValue(), name, description);
        }
    }

    private static <K> void addNumber(final ParentData<K> state, String name, String description, final FieldMatch fieldMatch, final Class<?> fieldClass) {
        Object instanceofType;
        boolean restrictToInt;
        final Range range = fieldMatch.field().getAnnotation(Range.class);
        if (range != null) {
            description = (String)description + (((String)description).length() > 0 ? " " : "") + ConfigHelper.asString(range);
        }
        boolean bl = restrictToInt = (instanceofType = ConfigHelper.convertDouble(fieldClass, 0.1)) instanceof Integer || instanceofType instanceof Long || instanceofType instanceof BigInteger || instanceofType instanceof Short || instanceofType instanceof Byte;
        if (range != null && range.max() - range.min() < 1000.0) {
            final double range2 = range.max() - range.min();
            TranslucentSliderWidget widget = new TranslucentSliderWidget(0, 0, GuiMaker.width(), 20, TextComponent.f_131282_, ((Number)GuiMaker.getValue(fieldMatch, state.obj)).doubleValue() / range2){

                protected void m_5695_() {
                    String format = restrictToInt ? "%f" : "%.3f";
                    this.m_93666_((Component)new TranslatableComponent("flytre_lib.gui.slider", new Object[]{String.format(format, ((Number)GuiMaker.getValue(fieldMatch, state.obj)).doubleValue())}));
                }

                protected void m_5697_() {
                    Object val = ConfigHelper.convertDouble(fieldClass, Double.parseDouble(String.format("%.3f", range2 * this.f_93577_ + range.min())));
                    GuiMaker.setValue(fieldMatch, state.obj, val);
                }
            };
            state.screen.addEntry(new ConfigListWidget.ConfigEntry((AbstractWidget)widget, name, (String)description));
        } else {
            NumberBox.ValueRange valueRange = range == null ? null : new NumberBox.ValueRange(range.min(), range.max());
            NumberBox widget = new NumberBox(0, 0, Math.min(230, ConfigHelper.getWidth() - 20), 20, TextComponent.f_131282_, restrictToInt, ((Number)GuiMaker.getValue(fieldMatch, state.obj)).doubleValue(), valueRange);
            widget.setListener(str -> GuiMaker.setValue(fieldMatch, state.obj, ConfigHelper.convertDouble(fieldClass, Double.parseDouble(str))));
            state.screen.addEntry(new ConfigListWidget.ConfigEntry(widget, name, (String)description));
        }
    }

    private static void addString(TranslucentTextField field, ParentData<?> state, FieldMatch fieldMatch, JsonElement jsonString, String name, String description) {
        state.screen.addEntry(new ConfigListWidget.ConfigEntry(GuiMaker.formatTextField(field, jsonString, fieldMatch, state.obj, state.handler), name, description));
    }

    private static <K extends TranslucentTextField> K formatTextField(K textField, JsonElement jsonString, FieldMatch match, Object object, ConfigHandler<?> handler) {
        textField.setText(jsonString.getAsString());
        TypeToken token = TypeToken.get((Type)match.field().getGenericType());
        textField.setListener(i -> {
            Object val = handler.getGson().fromJson(handler.getGson().toJson(i), token.getType());
            GuiMaker.setValue(match, object, val);
        });
        return textField;
    }

    private static void addBoolean(ParentData<?> state, FieldMatch fieldMatch, String name, String description) {
        TranslucentCyclingOption<Boolean> option = TranslucentCyclingOption.create("flytre_lib.gui.value", options -> (Boolean)GuiMaker.getValue(fieldMatch, state.obj), (game, opt, bool) -> GuiMaker.setValue(fieldMatch, state.obj, bool));
        AbstractWidget button = option.m_7496_(Minecraft.m_91087_().f_91066_, 0, 0, GuiMaker.width());
        state.screen.addEntry(new ConfigListWidget.ConfigEntry(button, name, description));
    }

    private static void addEnum(ParentData<?> state, Class<?> fieldClass, FieldMatch fieldMatch, JsonElement element, String name, String description) {
        Enum[] constants = (Enum[])fieldClass.getEnumConstants();
        if (constants.length <= 6) {
            TranslucentCyclingOption<Enum> option = TranslucentCyclingOption.create("flytre_lib.gui.value", constants, enumVal -> Component.m_130674_((String)ConfigHelper.getEnumName(enumVal, true)), options -> (Enum)GuiMaker.getValue(fieldMatch, state.obj), (game, opt, val) -> GuiMaker.setValue(fieldMatch, state.obj, val));
            AbstractWidget button = option.m_7496_(Minecraft.m_91087_().f_91066_, 0, 0, GuiMaker.width());
            state.screen.addEntry(new ConfigListWidget.ConfigEntry(button, name, description));
        } else {
            DropdownMenu menu = DropdownUtils.createGenericDropdown(0, 0, Arrays.stream(constants).map(i -> ConfigHelper.getEnumName(i, false)).collect(Collectors.toList()));
            GuiMaker.addString(menu, state, fieldMatch, element, name, description);
        }
    }

    private static <K> void addList(ParentData<K> state, FieldMatch fieldMatch, String name, String description) {
        Type type = fieldMatch.field().getGenericType();
        Type valueType = !(type instanceof ParameterizedType) ? type : ((ParameterizedType)type).getActualTypeArguments()[0];
        Consumer<List> consumer = list -> {
            Object val = state.handler.getGson().fromJson(state.handler.getGson().toJson(list), type);
            GuiMaker.setValue(fieldMatch, state.obj, val);
        };
        Supplier<TranslucentTextField> adder = GuiMaker.adder(TypeToken.get((Type)valueType).getRawType());
        TranslucentButton button = new TranslucentButton(0, 0, GuiMaker.width(), 20, (Component)new TranslatableComponent("flytre_lib.gui.edit"), but -> {
            List parsed;
            try {
                parsed = (List)state.handler.getGson().fromJson(state.handler.getGson().toJsonTree(GuiMaker.getValue(fieldMatch, state.obj)), new TypeToken<List<String>>(){}.getType());
            }
            catch (JsonParseException e) {
                but.m_93666_(Component.m_130674_((String)"Error: Edit Config Json"));
                return;
            }
            List initial = parsed.stream().sorted().map(arg_0 -> GuiMaker.lambda$addList$16((Supplier)adder, arg_0)).collect(Collectors.toList());
            Minecraft.m_91087_().m_91152_(new ListEditorScreen(state.screen, but, consumer, initial, adder, fieldMatch.field().getAnnotation(net.flytre.flytre_lib.api.config.annotation.Button.class)));
        });
        state.screen.addEntry(new ConfigListWidget.ConfigEntry((AbstractWidget)button, name, description));
    }

    private static int width() {
        return Math.min(250, ConfigHelper.getWidth());
    }

    private static void addMap(ParentData<?> state, FieldMatch fieldMatch, String name, String description) {
        TranslucentButton button = new TranslucentButton(0, 0, GuiMaker.width(), 20, (Component)new TranslatableComponent("flytre_lib.gui.edit"), but -> Minecraft.m_91087_().m_91152_((Screen)GuiMaker.mapScreenMaker(state, fieldMatch, (Map)GuiMaker.getValue(fieldMatch, state.obj), but)));
        state.screen.addEntry(new ConfigListWidget.ConfigEntry((AbstractWidget)button, name, description));
    }

    private static <T, E, K> MapEditorScreen mapScreenMaker(ParentData<K> state, FieldMatch fieldMatch, Map<T, E> rawValues, Button reopen) {
        Populator annotation;
        MapEditorScreen mapEditor = new MapEditorScreen(state.screen, fieldMatch.field().getAnnotation(net.flytre.flytre_lib.api.config.annotation.Button.class), reopen);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (player != null && world != null && (annotation = fieldMatch.field().getAnnotation(Populator.class)) != null) {
            try {
                BiFunction<ClientLevel, LocalPlayer, Map<?, ?>> function = annotation.value().getConstructor(new Class[0]).newInstance(new Object[0]);
                Map<?, ?> values = function.apply(world, player);
                for (Object key : values.keySet()) {
                    if (!annotation.replace()) {
                        rawValues.putIfAbsent(key, values.get(key));
                        continue;
                    }
                    rawValues.put(key, values.get(key));
                }
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, AbstractWidget> values = new HashMap<String, AbstractWidget>();
        HashMap wrappedValues = new HashMap();
        for (Map.Entry mapEntry : rawValues.entrySet()) {
            String key = (String)state.handler.getGson().fromJson(state.handler.getGson().toJson(mapEntry.getKey()), String.class);
            JsonElement element = state.handler.getGson().toJsonTree(mapEntry.getValue());
            if (element instanceof JsonObject) {
                TranslucentButton button = new TranslucentButton(0, 0, GuiMaker.width(), 20, (Component)new TranslatableComponent("flytre_lib.gui.open"), but -> {
                    IndividualConfigScreen simulator = new IndividualConfigScreen(mapEditor, but, state.handler);
                    GuiMaker.createGuiHelper(new ParentData(simulator, state.handler, mapEntry.getValue().getClass(), (JsonObject)element, mapEntry.getValue(), (JsonObject)element, mapEntry.getValue()));
                    Minecraft.m_91087_().m_91152_(simulator);
                });
                values.put(key, (AbstractWidget)button);
                continue;
            }
            IndividualConfigScreen simulator = new IndividualConfigScreen(mapEditor, reopen, state.handler);
            ObjectWrapper<?> wrapper = GuiMaker.create(fieldMatch, mapEntry.getValue());
            wrappedValues.put(key, wrapper);
            JsonElement elementInner = state.handler.getGson().toJsonTree(wrapper);
            GuiMaker.createGuiHelper(new ParentData(simulator, state.handler, wrapper.getClass(), (JsonObject)elementInner, wrapper, (JsonObject)elementInner, wrapper));
            AbstractWidget widget = simulator.getEntries().get(0).getValue();
            values.put(key, widget);
        }
        if (!wrappedValues.isEmpty()) {
            mapEditor.setWrappedElements(wrappedValues, fieldMatch, state.handler, state.obj);
        }
        mapEditor.setValues(values);
        return mapEditor;
    }

    private static ObjectWrapper<?> create(FieldMatch match, Object wrappedValue) {
        Type generic = ((ParameterizedType)match.field().getGenericType()).getActualTypeArguments()[1];
        Class clazz = TypeToken.get((Type)generic).getRawType();
        return new ObjectWrapper(clazz.cast(wrappedValue));
    }

    private static Supplier<TranslucentTextField> adder(Class<?> clazz) {
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        if (IS_ITEM.test(clazz)) {
            return () -> DropdownUtils.createItemDropdown(0, 0);
        }
        if (IS_FLUID.test(clazz)) {
            return () -> DropdownUtils.createFluidDropdown(0, 0);
        }
        if (IS_BLOCK.test(clazz)) {
            return () -> DropdownUtils.createBlockDropdown(0, 0);
        }
        if (IS_ENTITY.test(clazz)) {
            return () -> DropdownUtils.createEntityDropdown(0, 0);
        }
        if (IS_IDENTIFIER.test(clazz)) {
            return () -> {
                TranslucentTextField searchField = new TranslucentTextField(0, 0, Math.min(250, width), 20, (Component)new TranslatableComponent("null"));
                searchField.setRenderer(DropdownUtils::identifierTextFieldRenderer);
                return searchField;
            };
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return () -> {
                boolean integers = Long.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz);
                return new NumberBox(0, 0, Math.min(230, width - 20), 20, TextComponent.f_131282_, integers, 0.0, null);
            };
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            Enum[] constants = (Enum[])clazz.getEnumConstants();
            return () -> DropdownUtils.createGenericDropdown(Arrays.stream(constants).map(Enum::name).collect(Collectors.toList()));
        }
        return () -> new TranslucentTextField(0, 0, GuiMaker.width(), 20, (Component)new TranslatableComponent("null"));
    }

    public static Runnable getRunnable(@Nullable net.flytre.flytre_lib.api.config.annotation.Button button) {
        try {
            return button == null ? null : button.function().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setValue(FieldMatch field, Object objectWithTheField, Object value) {
        try {
            field.field().set(objectWithTheField, value);
        }
        catch (ClassCastException | IllegalAccessException e) {
            throw new ConfigError((Object)e);
        }
    }

    public static Object getValue(FieldMatch field, Object objectWithTheField) {
        try {
            return field.field().get(objectWithTheField);
        }
        catch (IllegalAccessException e) {
            throw new ConfigError((Object)e);
        }
    }

    private static /* synthetic */ TranslucentTextField lambda$addList$16(Supplier adder, String i) {
        return ((TranslucentTextField)((Object)adder.get())).withText(i);
    }

    public static class ParentData<K> {
        public final IndividualConfigScreen<K> screen;
        public final ConfigHandler<K> handler;
        public final JsonObject json;
        public final Class<?> clazz;
        public final Object obj;
        private final Object defObj;
        private final JsonObject defJson;

        public ParentData(IndividualConfigScreen<K> screen, ConfigHandler<K> handler, Class<?> clazz, JsonObject json, Object obj, JsonObject defJson, Object defObj) {
            this.screen = screen;
            this.handler = handler;
            this.json = json;
            this.clazz = clazz;
            this.obj = obj;
            this.defObj = defObj;
            this.defJson = defJson;
        }

        public String toString() {
            return "ParentData{screen=" + this.screen + ", handler=" + this.handler + ", json=" + this.json + ", clazz=" + this.clazz + ", obj=" + this.obj + ", defObj=" + this.defObj + ", defJson=" + this.defJson + "}";
        }
    }
}

