/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.loader;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.flytre.flytre_lib.loader.LoaderAgnosticClientRegistry;
import net.flytre.flytre_lib.loader.ScreenFactory;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

final class LoaderAgnosticClientRegistryImpl
implements LoaderAgnosticClientRegistry.Delegate {
    private static final List<BlockEntityRendererEntry<?>> BLOCK_ENTITY_RENDERERS = new ArrayList();
    private static final List<EntityRendererEntry<?>> ENTITY_RENDERERS = new ArrayList();
    private static final List<ScreenRegistryEntry<?, ?>> SCREEN_REGISTRY_ENTRIES = new ArrayList();

    private LoaderAgnosticClientRegistryImpl() {
    }

    public static List<BlockEntityRendererEntry<?>> getBlockEntityRenderers() {
        return ImmutableList.copyOf(BLOCK_ENTITY_RENDERERS);
    }

    public static List<EntityRendererEntry<?>> getEntityRenderers() {
        return ImmutableList.copyOf(ENTITY_RENDERERS);
    }

    public static List<ScreenRegistryEntry<?, ?>> getScreenRegistryEntries() {
        return SCREEN_REGISTRY_ENTRIES;
    }

    public static void init() {
        LoaderAgnosticClientRegistry.setDelegate(new LoaderAgnosticClientRegistryImpl());
    }

    @Override
    public <H extends AbstractContainerMenu, S extends Screen> void register(Supplier<MenuType<? extends H>> type, ScreenFactory<H, S> screenFactory) {
        SCREEN_REGISTRY_ENTRIES.add(new ScreenRegistryEntry<H, S>(type, screenFactory));
    }

    @Override
    public <E extends BlockEntity> void register(Supplier<BlockEntityType<E>> blockEntityType, BlockEntityRendererProvider<? super E> blockEntityRendererFactory) {
        BLOCK_ENTITY_RENDERERS.add(new BlockEntityRendererEntry<E>(blockEntityType, blockEntityRendererFactory));
    }

    @Override
    public <T extends Entity> void register(Supplier<EntityType<? extends T>> type, EntityRendererProvider<T> factory) {
        ENTITY_RENDERERS.add(new EntityRendererEntry<T>(type, factory));
    }

    record ScreenRegistryEntry<H extends AbstractContainerMenu, S extends Screen>(Supplier<MenuType<? extends H>> type, ScreenFactory<H, S> screenFactory) {
    }

    record BlockEntityRendererEntry<E extends BlockEntity>(Supplier<BlockEntityType<E>> blockEntityType, BlockEntityRendererProvider<? super E> blockEntityRendererFactory) {
    }

    record EntityRendererEntry<T extends Entity>(Supplier<EntityType<? extends T>> type, EntityRendererProvider<T> factory) {
    }
}

