/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.loader;

import java.util.function.Supplier;
import net.flytre.flytre_lib.loader.ExtendedScreenHandlerFactory;
import net.flytre.flytre_lib.loader.SimpleScreenHandlerFactory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public final class LoaderAgnosticRegistry {
    private static Delegate DELEGATE;

    private LoaderAgnosticRegistry() {
        throw new AssertionError();
    }

    public static void setDelegate(Delegate delegate) {
        DELEGATE = delegate;
    }

    public static <T extends Block> Supplier<T> registerBlock(Supplier<T> block, String mod, String id) {
        return DELEGATE.registerBlock(block, mod, id);
    }

    public static <T extends Item> Supplier<T> registerItem(Supplier<T> item, String mod, String id) {
        return DELEGATE.registerItem(item, mod, id);
    }

    public static <E extends Entity, T extends EntityType<E>> Supplier<T> registerEntity(Supplier<T> entity, String mod, String id) {
        return DELEGATE.registerEntity(entity, mod, id);
    }

    public static <T extends AbstractContainerMenu> Supplier<MenuType<T>> registerSimpleScreen(SimpleScreenHandlerFactory<T> factory, String mod, String id) {
        return DELEGATE.registerSimpleScreen(factory, mod, id);
    }

    public static <T extends AbstractContainerMenu> Supplier<MenuType<T>> registerExtendedScreen(ExtendedScreenHandlerFactory<T> factory, String mod, String id) {
        return DELEGATE.registerExtendedScreen(factory, mod, id);
    }

    public static <K extends BlockEntity> Supplier<BlockEntityType<K>> registerBlockEntityType(Supplier<BlockEntityType<K>> type, String mod, String id) {
        return DELEGATE.registerBlockEntityType(type, mod, id);
    }

    public static <T extends RecipeSerializer<?>> Supplier<T> registerRecipe(Supplier<T> recipe, String mod, String id) {
        return DELEGATE.registerRecipe(recipe, mod, id);
    }

    static interface Delegate {
        public <T extends Block> Supplier<T> registerBlock(Supplier<T> var1, String var2, String var3);

        public <T extends Item> Supplier<T> registerItem(Supplier<T> var1, String var2, String var3);

        public <E extends Entity, T extends EntityType<E>> Supplier<T> registerEntity(Supplier<T> var1, String var2, String var3);

        public <T extends AbstractContainerMenu> Supplier<MenuType<T>> registerSimpleScreen(SimpleScreenHandlerFactory<T> var1, String var2, String var3);

        public <T extends AbstractContainerMenu> Supplier<MenuType<T>> registerExtendedScreen(ExtendedScreenHandlerFactory<T> var1, String var2, String var3);

        public <K extends BlockEntity> Supplier<BlockEntityType<K>> registerBlockEntityType(Supplier<BlockEntityType<K>> var1, String var2, String var3);

        public <T extends RecipeSerializer<?>> Supplier<T> registerRecipe(Supplier<T> var1, String var2, String var3);
    }
}

