/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.loader;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.flytre.flytre_lib.loader.RenderLayerRegistry;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

final class RenderLayerRegistryImpl
implements RenderLayerRegistry.Delegate {
    private static final List<Tuple<RenderType, Supplier<Block>>> BLOCK_LAYERS = new ArrayList<Tuple<RenderType, Supplier<Block>>>();
    private static final List<Tuple<RenderType, Supplier<Fluid>>> FLUID_LAYERS = new ArrayList<Tuple<RenderType, Supplier<Fluid>>>();

    private RenderLayerRegistryImpl() {
    }

    public static void init() {
        RenderLayerRegistry.setDelegate(new RenderLayerRegistryImpl());
    }

    @Override
    public void registerBlockLayer(RenderType type, Supplier<Block> block) {
        BLOCK_LAYERS.add((Tuple<RenderType, Supplier<Block>>)new Tuple((Object)type, block));
    }

    @Override
    public void registerFluidLayer(RenderType type, Supplier<Fluid> fluid) {
        FLUID_LAYERS.add((Tuple<RenderType, Supplier<Fluid>>)new Tuple((Object)type, fluid));
    }

    public static List<Tuple<RenderType, Supplier<Block>>> getBlockLayers() {
        return ImmutableList.copyOf(BLOCK_LAYERS);
    }

    public static List<Tuple<RenderType, Supplier<Fluid>>> getFluidLayers() {
        return ImmutableList.copyOf(FLUID_LAYERS);
    }
}

