/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.mixin.config;

import com.google.gson.GsonBuilder;
import com.mojang.authlib.Agent;
import com.mojang.authlib.UserType;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import com.mojang.util.UUIDTypeAdapter;
import java.net.Proxy;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.flytre.flytre_lib.api.config.ConfigHandler;
import net.flytre.flytre_lib.api.config.ConfigRegistry;
import net.flytre.flytre_lib.impl.config.init.FlytreLibConfig;
import net.flytre.flytre_lib.loader.LoaderProperties;
import net.minecraft.client.User;
import net.minecraft.client.main.Main;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Main.class})
class MainMixin {
    @Unique
    private static String name;
    @Unique
    private static String uuid;
    @Unique
    private static String token;
    @Unique
    private static String type;
    private static boolean successful;

    MainMixin() {
    }

    @Inject(method={"main"}, at={@At(value="HEAD")})
    private static void flytre_lib$login(String[] args, CallbackInfo ci) {
        LoaderProperties.HANDLER = new ConfigHandler<FlytreLibConfig>(new FlytreLibConfig(), "flytre_lib", new GsonBuilder().setPrettyPrinting().create());
        ConfigRegistry.registerClientConfig(LoaderProperties.HANDLER);
        if (!LoaderProperties.HANDLER.getConfig().login.shouldLogin) {
            return;
        }
        YggdrasilUserAuthentication userAuth = (YggdrasilUserAuthentication)new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString()).createUserAuthentication(Agent.MINECRAFT);
        userAuth.setUsername(LoaderProperties.HANDLER.getConfig().login.username);
        userAuth.setPassword(LoaderProperties.HANDLER.getConfig().login.password);
        try {
            userAuth.logIn();
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
            return;
        }
        successful = true;
        name = userAuth.getSelectedProfile().getName();
        uuid = UUIDTypeAdapter.fromUUID((UUID)userAuth.getSelectedProfile().getId());
        token = userAuth.getAuthenticatedToken();
        type = userAuth.getUserType().getName();
    }

    @Redirect(method={"main"}, at=@At(value="NEW", target="net/minecraft/client/util/Session"))
    private static User flytre_lib$auth_me(String username, String uuid2, String accessToken, Optional<String> xuid, Optional<String> clientId, User.Type accountType) {
        if (successful) {
            return new User(name, uuid, token, Optional.empty(), Optional.empty(), Objects.equals(type, UserType.LEGACY.getName()) ? User.Type.LEGACY : User.Type.MOJANG);
        }
        return new User(username, uuid2, accessToken, xuid, clientId, accountType);
    }

    static {
        successful = false;
    }
}

