/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.armors;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.thedragonteam.armorplus.ARPConfig;
import net.thedragonteam.armorplus.armors.base.BaseArmor;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.armorplus.util.ItemStackUtils;

public enum ARPArmorMaterial {
    COAL(BaseArmor.coalArmor, "coal", Items.field_151044_h, Blocks.field_150402_ci, TextFormatting.func_96300_b((String)ARPConfig.coalArmorItemNameColor)),
    LAPIS(BaseArmor.lapisArmor, "lapis", ItemStackUtils.getItemStack(Items.field_151100_aR, 4), Blocks.field_150368_y, TextFormatting.func_96300_b((String)ARPConfig.lapisArmorItemNameColor)),
    REDSTONE(BaseArmor.redstoneArmor, "redstone", Items.field_151137_ax, Blocks.field_150451_bX, TextFormatting.func_96300_b((String)ARPConfig.redstoneArmorItemNameColor)),
    EMERALD(BaseArmor.emeraldArmor, "emerald", Items.field_151166_bC, Blocks.field_150475_bE, TextFormatting.func_96300_b((String)ARPConfig.emeraldArmorItemNameColor)),
    OBSIDIAN(BaseArmor.obsidianArmor, "obsidian", Blocks.field_150343_Z, (Block)ModBlocks.compressedObsidian, TextFormatting.func_96300_b((String)ARPConfig.obsidianArmorItemNameColor)),
    LAVA(BaseArmor.lavaArmor, "lava", (Item)ModItems.lavaCrystal, ItemStackUtils.getItemStack(ModItems.lavaCrystal, 1), TextFormatting.func_96300_b((String)ARPConfig.lavaArmorItemNameColor)),
    GUARDIAN(BaseArmor.guardianArmor, "guardian", ItemStackUtils.getItemStack(ModItems.materials, 1).func_77973_b(), TextFormatting.func_96300_b((String)ARPConfig.guardianArmorItemNameColor)),
    SUPER_STAR(BaseArmor.superStarArmor, "super_star", ItemStackUtils.getItemStack(ModItems.materials, 2).func_77973_b(), TextFormatting.func_96300_b((String)ARPConfig.superStarArmorItemNameColor)),
    ENDER_DRAGON(BaseArmor.enderDragonArmor, "ender_dragon", ItemStackUtils.getItemStack(ModItems.materials, 3).func_77973_b(), TextFormatting.func_96300_b((String)ARPConfig.enderDragonArmorItemNameColor)),
    ARDITE(BaseArmor.arditeArmor, "ardite", ItemStackUtils.getTICItem("ingots", 1), ItemStackUtils.getTICItem("metal", 1), TextFormatting.func_96300_b((String)ARPConfig.arditeArmorItemNameColor)),
    COBALT(BaseArmor.cobaltArmor, "cobalt", ItemStackUtils.getTICItem("ingots", 0), ItemStackUtils.getTICItem("metal", 0), TextFormatting.func_96300_b((String)ARPConfig.cobaltArmorItemNameColor)),
    MANYULLYN(BaseArmor.manyullynArmor, "manyullyn", ItemStackUtils.getTICItem("ingots", 2), ItemStackUtils.getTICItem("metal", 2), TextFormatting.func_96300_b((String)ARPConfig.manyullynArmorItemNameColor)),
    KNIGHT_SLIME(BaseArmor.knightSlimeArmor, "knight_slime", ItemStackUtils.getTICItem("ingots", 3), ItemStackUtils.getTICItem("metal", 3), TextFormatting.func_96300_b((String)ARPConfig.knightSlimeArmorItemNameColor)),
    PIG_IRON(BaseArmor.pigIronArmor, "pig_iron", ItemStackUtils.getTICItem("ingots", 4), ItemStackUtils.getTICItem("metal", 4), TextFormatting.func_96300_b((String)ARPConfig.pigIronArmorItemNameColor)),
    SLIME(BaseArmor.slimeArmor, "slime", Items.field_151123_aH, Blocks.field_180399_cE, TextFormatting.func_96300_b((String)ARPConfig.slimeArmorItemNameColor)),
    CHICKEN(BaseArmor.chickenArmor, "chicken", Items.field_151008_G, TextFormatting.func_96300_b((String)ARPConfig.chickenArmorItemNameColor));

    private final ItemArmor.ArmorMaterial armorMaterial;
    private final String name;
    private final Item itemEasy;
    private final Item itemExpert;
    private final TextFormatting formatting;

    private ARPArmorMaterial(ItemArmor.ArmorMaterial armorMaterialIn, String nameIn, Item repairEasyIn, Item repairExpertIn, TextFormatting textFormattingIn) {
        this.armorMaterial = armorMaterialIn;
        this.name = nameIn;
        this.itemEasy = repairEasyIn;
        this.itemExpert = repairExpertIn;
        this.formatting = textFormattingIn;
    }

    private ARPArmorMaterial(ItemArmor.ArmorMaterial armorMaterialIn, String nameIn, Item repairBoth, TextFormatting textFormattingIn) {
        this(armorMaterialIn, nameIn, repairBoth, repairBoth, textFormattingIn);
    }

    private ARPArmorMaterial(ItemArmor.ArmorMaterial armorMaterial, String name, ItemStack repairEasy, ItemStack repairExpert, TextFormatting textFormatting) {
        this(armorMaterial, name, repairEasy.func_77973_b(), repairExpert.func_77973_b(), textFormatting);
    }

    private ARPArmorMaterial(ItemArmor.ArmorMaterial armorMaterial, String name, ItemStack repairEasy, Block repairExpert, TextFormatting textFormatting) {
        this(armorMaterial, name, repairEasy.func_77973_b(), Item.func_150898_a((Block)repairExpert), textFormatting);
    }

    private ARPArmorMaterial(ItemArmor.ArmorMaterial armorMaterial, String name, Item repairEasy, ItemStack repairExpert, TextFormatting textFormatting) {
        this(armorMaterial, name, repairEasy, repairExpert.func_77973_b(), textFormatting);
    }

    private ARPArmorMaterial(ItemArmor.ArmorMaterial armorMaterial, String name, Item repairEasy, Block repairExpert, TextFormatting textFormatting) {
        this(armorMaterial, name, repairEasy, Item.func_150898_a((Block)repairExpert), textFormatting);
    }

    private ARPArmorMaterial(ItemArmor.ArmorMaterial armorMaterial, String name, Block repairEasy, Block repairExpert, TextFormatting textFormatting) {
        this(armorMaterial, name, Item.func_150898_a((Block)repairEasy), Item.func_150898_a((Block)repairExpert), textFormatting);
    }

    public ItemArmor.ArmorMaterial getArmorMaterial() {
        return this.armorMaterial;
    }

    public String getName() {
        return this.name;
    }

    public Item getItemEasy() {
        return this.itemEasy;
    }

    public Item getItemExpert() {
        return this.itemExpert;
    }

    public TextFormatting getFormatting() {
        return this.formatting;
    }
}

