/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.armors.base;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.ARPConfig;
import net.thedragonteam.armorplus.ArmorPlus;
import net.thedragonteam.armorplus.armors.ARPArmorMaterial;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.armorplus.util.ParticlesHelper;
import net.thedragonteam.armorplus.util.PotionUtils;
import net.thedragonteam.armorplus.util.Utils;
import net.thedragonteam.thedragonlib.util.TextHelper;

public class BaseArmor
extends ItemArmor {
    public static ItemArmor.ArmorMaterial coalArmor = EnumHelper.addArmorMaterial((String)"coal", (String)ArmorPlus.getArmorPlusLocation("coal_armor"), (int)7, (int[])ARPConfig.coalArmorProtectionPoints, (int)8, (SoundEvent)SoundEvents.field_187728_s, (float)((float)ARPConfig.coalArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial emeraldArmor = EnumHelper.addArmorMaterial((String)"emerald", (String)ArmorPlus.getArmorPlusLocation("emerald_armor"), (int)35, (int[])ARPConfig.emeraldArmorProtectionPoints, (int)20, (SoundEvent)SoundEvents.field_187716_o, (float)((float)ARPConfig.emeraldArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial lapisArmor = EnumHelper.addArmorMaterial((String)"lapis", (String)ArmorPlus.getArmorPlusLocation("lapis_armor"), (int)11, (int[])ARPConfig.lapisArmorProtectionPoints, (int)25, (SoundEvent)SoundEvents.field_187722_q, (float)((float)ARPConfig.lapisArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial lavaArmor = EnumHelper.addArmorMaterial((String)"lava", (String)ArmorPlus.getArmorPlusLocation("lava_armor"), (int)45, (int[])ARPConfig.lavaArmorProtectionPoints, (int)28, (SoundEvent)SoundEvents.field_187716_o, (float)((float)ARPConfig.lavaArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial obsidianArmor = EnumHelper.addArmorMaterial((String)"obsidian", (String)ArmorPlus.getArmorPlusLocation("obsidian_armor"), (int)40, (int[])ARPConfig.obsidianArmorProtectionPoints, (int)25, (SoundEvent)SoundEvents.field_187716_o, (float)((float)ARPConfig.obsidianArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial redstoneArmor = EnumHelper.addArmorMaterial((String)"redstone", (String)ArmorPlus.getArmorPlusLocation("redstone_armor"), (int)11, (int[])ARPConfig.redstoneArmorProtectionPoints, (int)25, (SoundEvent)SoundEvents.field_187722_q, (float)((float)ARPConfig.redstoneArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial chickenArmor = EnumHelper.addArmorMaterial((String)"chicken", (String)ArmorPlus.getArmorPlusLocation("chicken_armor"), (int)3, (int[])ARPConfig.chickenArmorProtectionPoints, (int)10, (SoundEvent)SoundEvents.field_187728_s, (float)((float)ARPConfig.chickenArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial slimeArmor = EnumHelper.addArmorMaterial((String)"slime", (String)ArmorPlus.getArmorPlusLocation("slime_armor"), (int)3, (int[])ARPConfig.slimeArmorProtectionPoints, (int)10, (SoundEvent)SoundEvents.field_187728_s, (float)((float)ARPConfig.slimeArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial enderDragonArmor = EnumHelper.addArmorMaterial((String)"enderDragon", (String)ArmorPlus.getArmorPlusLocation("ender_dragon_armor"), (int)60, (int[])ARPConfig.enderDragonArmorProtectionPoints, (int)30, (SoundEvent)SoundEvents.field_187716_o, (float)((float)ARPConfig.enderDragonArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial guardianArmor = EnumHelper.addArmorMaterial((String)"guardian", (String)ArmorPlus.getArmorPlusLocation("guardian_armor"), (int)50, (int[])ARPConfig.guardianArmorProtectionPoints, (int)28, (SoundEvent)SoundEvents.field_187716_o, (float)((float)ARPConfig.guardianArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial superStarArmor = EnumHelper.addArmorMaterial((String)"superStar", (String)ArmorPlus.getArmorPlusLocation("super_star_armor"), (int)50, (int[])ARPConfig.superStarArmorProtectionPoints, (int)30, (SoundEvent)SoundEvents.field_187716_o, (float)((float)ARPConfig.superStarArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial arditeArmor = EnumHelper.addArmorMaterial((String)"ardite", (String)ArmorPlus.getArmorPlusLocation("ardite_armor"), (int)55, (int[])ARPConfig.arditeArmorProtectionPoints, (int)30, (SoundEvent)SoundEvents.field_187716_o, (float)((float)ARPConfig.arditeArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial cobaltArmor = EnumHelper.addArmorMaterial((String)"cobalt", (String)ArmorPlus.getArmorPlusLocation("cobalt_armor"), (int)44, (int[])ARPConfig.cobaltArmorProtectionPoints, (int)30, (SoundEvent)SoundEvents.field_187716_o, (float)((float)ARPConfig.cobaltArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial knightSlimeArmor = EnumHelper.addArmorMaterial((String)"knightSlime", (String)ArmorPlus.getArmorPlusLocation("knight_slime_armor"), (int)33, (int[])ARPConfig.knightSlimeArmorProtectionPoints, (int)10, (SoundEvent)SoundEvents.field_187716_o, (float)((float)ARPConfig.knightSlimeArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial manyullynArmor = EnumHelper.addArmorMaterial((String)"manyullyn", (String)ArmorPlus.getArmorPlusLocation("manyullyn_armor"), (int)66, (int[])ARPConfig.manyullynArmorProtectionPoints, (int)30, (SoundEvent)SoundEvents.field_187716_o, (float)((float)ARPConfig.manyullynArmorToughnessPoints));
    public static ItemArmor.ArmorMaterial pigIronArmor = EnumHelper.addArmorMaterial((String)"pigIron", (String)ArmorPlus.getArmorPlusLocation("pig_iron_armor"), (int)33, (int[])ARPConfig.pigIronArmorProtectionPoints, (int)10, (SoundEvent)SoundEvents.field_187716_o, (float)((float)ARPConfig.pigIronArmorToughnessPoints));
    public Item itemEasy;
    public Item itemExpert;
    public TextFormatting formatting;
    private ARPArmorMaterial material;
    private EntityEquipmentSlot slot;

    public BaseArmor(ARPArmorMaterial armorMaterial, EntityEquipmentSlot slot) {
        super(armorMaterial.getArmorMaterial(), 0, slot);
        this.itemEasy = armorMaterial.getItemEasy();
        this.itemExpert = armorMaterial.getItemExpert();
        this.formatting = armorMaterial.getFormatting();
        this.material = armorMaterial;
        this.slot = slot;
        this.func_77625_d(1);
        switch (slot) {
            case FEET: {
                String boots = armorMaterial.getName() + "_boots";
                this.setRegistryName(boots);
                this.func_77655_b(Utils.setName(boots));
                break;
            }
            case LEGS: {
                String leggings = armorMaterial.getName() + "_leggings";
                this.setRegistryName(leggings);
                this.func_77655_b(Utils.setName(leggings));
                break;
            }
            case CHEST: {
                String chestplate = armorMaterial.getName() + "_chestplate";
                this.setRegistryName(chestplate);
                this.func_77655_b(Utils.setName(chestplate));
                break;
            }
            case HEAD: {
                String helmet = armorMaterial.getName() + "_helmet";
                this.setRegistryName(helmet);
                this.func_77655_b(Utils.setName(helmet));
            }
        }
        GameRegistry.register((IForgeRegistryEntry)this);
        this.func_77637_a(ArmorPlus.tabArmorplus);
    }

    public void onArmorTick(World world, EntityPlayer entity, ItemStack itemStack) {
        ItemStack head = entity.func_184582_a(EntityEquipmentSlot.HEAD);
        ItemStack chest = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack legs = entity.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack feet = entity.func_184582_a(EntityEquipmentSlot.FEET);
        block0 : switch (this.material) {
            case COAL: {
                switch (this.slot) {
                    case FEET: {
                        if (ARPConfig.enableCoalBEffect && !ARPConfig.enableFullCoalArmorEffect) {
                            PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.coalArmorAddPotionEffect), 240, ARPConfig.coalArmorEffectLevel, 'G');
                        }
                    }
                    case LEGS: {
                        if (ARPConfig.enableCoalLEffect && !ARPConfig.enableFullCoalArmorEffect) {
                            PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.coalArmorAddPotionEffect), 240, ARPConfig.coalArmorEffectLevel, 'G');
                        }
                    }
                    case CHEST: {
                        if (ARPConfig.enableCoalCEffect && !ARPConfig.enableFullCoalArmorEffect) {
                            PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.coalArmorAddPotionEffect), 240, ARPConfig.coalArmorEffectLevel, 'G');
                        }
                    }
                    case HEAD: {
                        if (!ARPConfig.enableCoalHEffect || ARPConfig.enableFullCoalArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.coalArmorAddPotionEffect), 240, ARPConfig.coalArmorEffectLevel, 'G');
                    }
                }
                break;
            }
            case EMERALD: {
                switch (this.slot) {
                    case FEET: {
                        if (!ARPConfig.enableEmeraldBEffect || ARPConfig.enableFullEmeraldArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.emeraldArmorAddPotionEffect), ARPConfig.emeraldArmorEffectLevel, 'G');
                        break;
                    }
                    case LEGS: {
                        if (!ARPConfig.enableEmeraldLEffect || ARPConfig.enableFullEmeraldArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.emeraldArmorAddPotionEffect), ARPConfig.emeraldArmorEffectLevel, 'G');
                        break;
                    }
                    case CHEST: {
                        if (!ARPConfig.enableEmeraldCEffect || ARPConfig.enableFullEmeraldArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.emeraldArmorAddPotionEffect), ARPConfig.emeraldArmorEffectLevel, 'G');
                        break;
                    }
                    case HEAD: {
                        if (!ARPConfig.enableEmeraldHEffect || ARPConfig.enableFullEmeraldArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.emeraldArmorAddPotionEffect), ARPConfig.emeraldArmorEffectLevel, 'G');
                    }
                }
                break;
            }
            case LAPIS: {
                switch (this.slot) {
                    case FEET: {
                        if (!ARPConfig.enableLapisBEffect || ARPConfig.enableFullLapisArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.lapisArmorAddPotionEffect), ARPConfig.lapisArmorEffectLevel, 'G');
                        break;
                    }
                    case LEGS: {
                        if (!ARPConfig.enableLapisLEffect || ARPConfig.enableFullLapisArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.lapisArmorAddPotionEffect), ARPConfig.lapisArmorEffectLevel, 'G');
                        break;
                    }
                    case CHEST: {
                        if (!ARPConfig.enableLapisCEffect || ARPConfig.enableFullLapisArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.lapisArmorAddPotionEffect), ARPConfig.lapisArmorEffectLevel, 'G');
                        break;
                    }
                    case HEAD: {
                        if (!ARPConfig.enableLapisHEffect || ARPConfig.enableFullLapisArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.lapisArmorAddPotionEffect), ARPConfig.lapisArmorEffectLevel, 'G');
                    }
                }
                break;
            }
            case LAVA: {
                switch (this.slot) {
                    case FEET: {
                        if (ARPConfig.enableLavaBEffect && !ARPConfig.enableFullLavaArmorEffect) {
                            PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.lavaArmorAddPotionEffect), ARPConfig.lavaArmorEffectLevel, 'G');
                        }
                        this.lavaEffects(entity, itemStack);
                        break;
                    }
                    case LEGS: {
                        if (ARPConfig.enableLavaLEffect && !ARPConfig.enableFullLavaArmorEffect) {
                            PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.lavaArmorAddPotionEffect), ARPConfig.lavaArmorEffectLevel, 'G');
                        }
                        this.lavaEffects(entity, itemStack);
                        break;
                    }
                    case CHEST: {
                        if (ARPConfig.enableLavaCEffect && !ARPConfig.enableFullLavaArmorEffect) {
                            PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.lavaArmorAddPotionEffect), ARPConfig.lavaArmorEffectLevel, 'G');
                        }
                        this.lavaEffects(entity, itemStack);
                        break;
                    }
                    case HEAD: {
                        if (ARPConfig.enableLavaHEffect && !ARPConfig.enableFullLavaArmorEffect) {
                            PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.lavaArmorAddPotionEffect), ARPConfig.lavaArmorEffectLevel, 'G');
                        }
                        this.lavaEffects(entity, itemStack);
                    }
                }
                break;
            }
            case REDSTONE: {
                switch (this.slot) {
                    case FEET: {
                        if (!ARPConfig.enableRedstoneBEffect || ARPConfig.enableFullRedstoneArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.redstoneArmorAddPotionEffect), ARPConfig.redstoneArmorEffectLevel, 'G');
                        if (!world.field_72995_K) break;
                        ParticlesHelper.spawnParticle((Entity)entity, EnumParticleTypes.REDSTONE, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                        break;
                    }
                    case LEGS: {
                        if (!ARPConfig.enableRedstoneLEffect || ARPConfig.enableFullRedstoneArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.redstoneArmorAddPotionEffect), ARPConfig.redstoneArmorEffectLevel, 'G');
                        if (!world.field_72995_K) break;
                        ParticlesHelper.spawnParticle((Entity)entity, EnumParticleTypes.REDSTONE, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                        break;
                    }
                    case CHEST: {
                        if (!ARPConfig.enableRedstoneCEffect || ARPConfig.enableFullRedstoneArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.redstoneArmorAddPotionEffect), ARPConfig.redstoneArmorEffectLevel, 'G');
                        if (!world.field_72995_K) break;
                        ParticlesHelper.spawnParticle((Entity)entity, EnumParticleTypes.REDSTONE, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                        break;
                    }
                    case HEAD: {
                        if (!ARPConfig.enableRedstoneHEffect || ARPConfig.enableFullRedstoneArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.redstoneArmorAddPotionEffect), ARPConfig.redstoneArmorEffectLevel, 'G');
                        if (!world.field_72995_K) break;
                        ParticlesHelper.spawnParticle((Entity)entity, EnumParticleTypes.REDSTONE, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    }
                }
                break;
            }
            case OBSIDIAN: {
                switch (this.slot) {
                    case FEET: {
                        if (!ARPConfig.enableObsidianBEffect || ARPConfig.enableFullObsidianArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.obsidianArmorAddPotionEffect), ARPConfig.obsidianArmorEffectLevel, 'G');
                        break;
                    }
                    case LEGS: {
                        if (!ARPConfig.enableObsidianLEffect || ARPConfig.enableFullObsidianArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.obsidianArmorAddPotionEffect), ARPConfig.obsidianArmorEffectLevel, 'G');
                        break;
                    }
                    case CHEST: {
                        if (!ARPConfig.enableObsidianCEffect || ARPConfig.enableFullObsidianArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.obsidianArmorAddPotionEffect), ARPConfig.obsidianArmorEffectLevel, 'G');
                        break;
                    }
                    case HEAD: {
                        if (!ARPConfig.enableObsidianHEffect || ARPConfig.enableFullObsidianArmorEffect) break;
                        PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.obsidianArmorAddPotionEffect), ARPConfig.obsidianArmorEffectLevel, 'G');
                    }
                }
                break;
            }
            case ENDER_DRAGON: {
                if (ARPConfig.enableFlightAbility) {
                    if (head != null && head.func_77973_b() == ModItems.enderDragonHelmet && chest != null && chest.func_77973_b() == ModItems.enderDragonChestplate && legs != null && legs.func_77973_b() == ModItems.enderDragonLeggings && feet != null && feet.func_77973_b() == ModItems.enderDragonBoots || entity.field_71075_bZ.field_75098_d || entity.func_175149_v()) {
                        entity.field_71075_bZ.field_75101_c = true;
                    } else {
                        entity.field_71075_bZ.field_75100_b = false;
                        entity.field_71075_bZ.field_75101_c = false;
                    }
                }
                if (PotionUtils.getPotion(ARPConfig.enderDragonArmorRemovePotionEffect) == null) break;
                PotionUtils.removeEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.enderDragonArmorRemovePotionEffect));
                break;
            }
            case SUPER_STAR: {
                switch (this.slot) {
                    case FEET: {
                        if (ARPConfig.enableSuperStarBEffect && !ARPConfig.enableFullSuperStarArmorEffect && entity.func_70660_b(PotionUtils.getPotion(ARPConfig.superStarArmorAddPotionEffect)) == null) {
                            PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.superStarArmorAddPotionEffect), ARPConfig.superStarArmorEffectLevel, 'G');
                        }
                        PotionUtils.removeEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.superStarArmorRemovePotionEffect));
                        break block0;
                    }
                    case LEGS: {
                        if (ARPConfig.enableSuperStarLEffect && !ARPConfig.enableFullSuperStarArmorEffect && entity.func_70660_b(PotionUtils.getPotion(ARPConfig.superStarArmorAddPotionEffect)) == null) {
                            PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.superStarArmorAddPotionEffect), ARPConfig.superStarArmorEffectLevel, 'G');
                        }
                        PotionUtils.removeEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.superStarArmorRemovePotionEffect));
                        break block0;
                    }
                    case CHEST: {
                        if (ARPConfig.enableSuperStarCEffect && !ARPConfig.enableFullSuperStarArmorEffect && entity.func_70660_b(PotionUtils.getPotion(ARPConfig.superStarArmorAddPotionEffect)) == null) {
                            PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.superStarArmorAddPotionEffect), ARPConfig.superStarArmorEffectLevel, 'G');
                        }
                        PotionUtils.removeEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.superStarArmorRemovePotionEffect));
                        break block0;
                    }
                    case HEAD: {
                        if (ARPConfig.enableSuperStarHEffect && !ARPConfig.enableFullSuperStarArmorEffect && entity.func_70660_b(PotionUtils.getPotion(ARPConfig.superStarArmorAddPotionEffect)) == null) {
                            PotionUtils.addEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.superStarArmorAddPotionEffect), ARPConfig.superStarArmorEffectLevel, 'G');
                        }
                        PotionUtils.removeEffect((EntityLivingBase)entity, PotionUtils.getPotion(ARPConfig.superStarArmorRemovePotionEffect));
                    }
                }
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        return (this.formatting + TextHelper.localize((String)(this.func_77657_g(stack) + ".name"), (Object[])new Object[0])).trim();
    }

    public void lavaEffects(EntityPlayer entity, ItemStack itemStack) {
        if (!ARPConfig.enableFullLavaArmorEffect) {
            entity.func_70066_B();
            entity.func_110149_m(entity.func_180799_ab() ? 4.0f : 0.0f);
        }
        if (entity.func_70090_H() && !ARPConfig.enableFullLavaArmorEffect && entity.func_70660_b(MobEffects.field_76427_o) == null) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 120, 1, true, true));
            itemStack.func_77972_a(1, (EntityLivingBase)entity);
            entity.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        switch (ARPConfig.recipes) {
            case 0: {
                return Objects.equals(repair.func_77973_b(), this.itemEasy);
            }
            case 1: {
                return Objects.equals(repair.func_77973_b(), this.itemExpert);
            }
        }
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        switch (this.material) {
            case COAL: {
                if (this.isKeyDown()) {
                    if (!ARPConfig.enableFullCoalArmorEffect) {
                        this.addToolTipPiece(tooltip, PotionUtils.localizePotion(ARPConfig.coalArmorAddPotionEffect), ARPConfig.coalArmorEffectLevel);
                        break;
                    }
                    this.addToolTipFull(tooltip, PotionUtils.localizePotion(ARPConfig.coalArmorAddPotionEffect), ARPConfig.coalArmorEffectLevel);
                    break;
                }
                this.showInfo(tooltip, keyBindSneak);
                break;
            }
            case EMERALD: {
                if (this.isKeyDown()) {
                    if (!ARPConfig.enableFullEmeraldArmorEffect) {
                        this.addToolTipPiece(tooltip, PotionUtils.localizePotion(ARPConfig.emeraldArmorAddPotionEffect), ARPConfig.emeraldArmorEffectLevel);
                        break;
                    }
                    this.addToolTipFull(tooltip, PotionUtils.localizePotion(ARPConfig.emeraldArmorAddPotionEffect), ARPConfig.emeraldArmorEffectLevel);
                    break;
                }
                this.showInfo(tooltip, keyBindSneak);
                break;
            }
            case LAPIS: {
                if (this.isKeyDown()) {
                    if (!ARPConfig.enableFullLapisArmorEffect) {
                        this.addToolTipPiece(tooltip, PotionUtils.localizePotion(ARPConfig.lapisArmorAddPotionEffect), ARPConfig.lapisArmorEffectLevel);
                        break;
                    }
                    this.addToolTipFull(tooltip, PotionUtils.localizePotion(ARPConfig.lapisArmorAddPotionEffect), ARPConfig.lapisArmorEffectLevel);
                    break;
                }
                this.showInfo(tooltip, keyBindSneak);
                break;
            }
            case LAVA: {
                if (this.isKeyDown()) {
                    if (!ARPConfig.enableFullLavaArmorEffect) {
                        this.addToolTipPiece(tooltip, PotionUtils.localizePotion(ARPConfig.lavaArmorAddPotionEffect), ARPConfig.lavaArmorEffectLevel);
                        break;
                    }
                    this.addToolTipFull(tooltip, PotionUtils.localizePotion(ARPConfig.lavaArmorAddPotionEffect), ARPConfig.lavaArmorEffectLevel);
                    break;
                }
                this.showInfo(tooltip, keyBindSneak);
                break;
            }
            case REDSTONE: {
                if (this.isKeyDown()) {
                    if (!ARPConfig.enableFullRedstoneArmorEffect) {
                        this.addToolTipPiece(tooltip, PotionUtils.localizePotion(ARPConfig.redstoneArmorAddPotionEffect), ARPConfig.redstoneArmorEffectLevel);
                        break;
                    }
                    this.addToolTipFull(tooltip, PotionUtils.localizePotion(ARPConfig.redstoneArmorAddPotionEffect), ARPConfig.redstoneArmorEffectLevel);
                    break;
                }
                this.showInfo(tooltip, keyBindSneak);
                break;
            }
            case OBSIDIAN: {
                if (this.isKeyDown()) {
                    if (!ARPConfig.enableFullObsidianArmorEffect) {
                        this.addToolTipPiece(tooltip, PotionUtils.localizePotion(ARPConfig.obsidianArmorAddPotionEffect), ARPConfig.obsidianArmorEffectLevel);
                        break;
                    }
                    this.addToolTipFull(tooltip, PotionUtils.localizePotion(ARPConfig.obsidianArmorAddPotionEffect), ARPConfig.obsidianArmorEffectLevel);
                    break;
                }
                this.showInfo(tooltip, keyBindSneak);
                break;
            }
            case ENDER_DRAGON: {
                if (this.isKeyDown()) {
                    this.addToolTipFull(tooltip, "Flight");
                    break;
                }
                this.showInfo(tooltip, keyBindSneak);
                break;
            }
            case GUARDIAN: {
                if (this.isKeyDown()) {
                    this.addToolTipFull(tooltip, PotionUtils.localizePotion(ARPConfig.guardianArmorAddPotionEffect), ARPConfig.guardianArmorEffectLevel);
                    break;
                }
                this.showInfo(tooltip, keyBindSneak);
                break;
            }
            case SLIME: {
                if (this.isKeyDown()) {
                    this.addToolTipFull(tooltip, PotionUtils.localizePotion(ARPConfig.slimeArmorAddPotionEffect), ARPConfig.slimeArmorEffectLevel);
                    break;
                }
                this.showInfo(tooltip, keyBindSneak);
                break;
            }
            case CHICKEN: {
                if (this.isKeyDown()) {
                    this.addToolTipFull(tooltip, PotionUtils.localizePotion(ARPConfig.chickenArmorAddPotionEffect), ARPConfig.chickenArmorEffectLevel);
                    break;
                }
                this.showInfo(tooltip, keyBindSneak);
                break;
            }
            case SUPER_STAR: {
                if (this.isKeyDown()) {
                    if (!ARPConfig.enableFullObsidianArmorEffect) {
                        this.addToolTipPiece(tooltip, PotionUtils.localizePotion(ARPConfig.superStarArmorAddPotionEffect), ARPConfig.superStarArmorEffectLevel);
                        break;
                    }
                    this.addToolTipFull(tooltip, PotionUtils.localizePotion(ARPConfig.superStarArmorAddPotionEffect), ARPConfig.superStarArmorEffectLevel);
                    break;
                }
                this.showInfo(tooltip, keyBindSneak);
                break;
            }
            case ARDITE: {
                if (this.isKeyDown()) {
                    this.addToolTipFull(tooltip, PotionUtils.localizePotion(ARPConfig.arditeArmorAddPotionEffect), ARPConfig.arditeArmorEffectLevel);
                    break;
                }
                this.showInfo(tooltip, keyBindSneak);
                break;
            }
            case COBALT: {
                if (this.isKeyDown()) {
                    this.addToolTipFull(tooltip, PotionUtils.localizePotion(ARPConfig.cobaltArmorAddPotionEffect), ARPConfig.cobaltArmorEffectLevel);
                    break;
                }
                this.showInfo(tooltip, keyBindSneak);
                break;
            }
            case MANYULLYN: {
                if (this.isKeyDown()) {
                    this.addToolTipFull(tooltip, PotionUtils.localizePotion(ARPConfig.manyullynArmorAddPotionEffect), ARPConfig.manyullynArmorEffectLevel);
                    break;
                }
                this.showInfo(tooltip, keyBindSneak);
                break;
            }
            case KNIGHT_SLIME: {
                if (this.isKeyDown()) {
                    this.addToolTipFull(tooltip, PotionUtils.localizePotion(ARPConfig.knightSlimeArmorAddPotionEffect), ARPConfig.knightSlimeArmorEffectLevel);
                    break;
                }
                this.showInfo(tooltip, keyBindSneak);
                break;
            }
            case PIG_IRON: {
                if (this.isKeyDown()) {
                    this.addToolTipFull(tooltip, PotionUtils.localizePotion(ARPConfig.pigIronArmorAddPotionEffect), ARPConfig.pigIronArmorEffectLevel);
                    break;
                }
                this.showInfo(tooltip, keyBindSneak);
            }
        }
    }

    private void showInfo(List<String> tooltip, KeyBinding keyBinding) {
        tooltip.add(I18n.func_135052_a((String)"tooltip.shift.showinfo", (Object[])new Object[]{this.formatting, keyBinding.getDisplayName(), TextFormatting.GRAY}));
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    private void addToolTipFull(List<String> tooltip, String ability, int amplifier) {
        this.addToolTipFull(tooltip, ability + " " + (amplifier + 1));
    }

    private void addToolTipFull(List<String> tooltip, String ability) {
        tooltip.add("\u00a79Ability: \u00a7r" + ability);
        tooltip.add("\u00a73Use: \u00a7rEquip The Full Set");
    }

    private void addToolTipPiece(List<String> tooltip, String ability, int amplifier) {
        this.addToolTipPiece(tooltip, ability + " " + (amplifier + 1));
    }

    private void addToolTipPiece(List<String> tooltip, String ability) {
        tooltip.add("\u00a79Ability: \u00a7r" + ability);
        tooltip.add("\u00a73Use: \u00a7rEquip A Piece");
    }

    public boolean isKeyDown() {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        return GameSettings.func_100015_a((KeyBinding)keyBindSneak);
    }
}

