/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.blocks.multiblock;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.thedragonteam.armorplus.blocks.multiblock.MultiBlockComponent;
import net.thedragonteam.armorplus.blocks.multiblock.MultiBlockSet;
import net.thedragonteam.thedragonlib.util.LogHelper;

public class MultiBlock {
    public final List<MultiBlockComponent> components = new ArrayList<MultiBlockComponent>();
    public final List<ItemStack> materials = new ArrayList<ItemStack>();
    public BlockPos minPos = BlockPos.field_177992_a;
    public BlockPos maxPos = BlockPos.field_177992_a;
    public BlockPos offPos = BlockPos.field_177992_a;
    public final HashMap<BlockPos, MultiBlockComponent> locationCache = new HashMap();

    public void addComponent(MultiBlockComponent component) {
        if (this.getComponentForLocation(component.getRelativePosition()) != null) {
            LogHelper.info((Object)"Overlapping blocks in multi-block structure!");
        }
        this.components.add(component);
        this.changeAxisForNewComponent(component.getRelativePosition());
        this.calculateCostForNewComponent(component);
        this.addComponentToLocationCache(component);
    }

    public void addComponent(BlockPos pos, IBlockState state) {
        this.addComponent(new MultiBlockComponent(pos, state));
    }

    private void changeAxisForNewComponent(BlockPos pos) {
        if (pos.func_177958_n() < this.minPos.func_177958_n()) {
            this.minPos = new BlockPos(pos.func_177958_n(), this.minPos.func_177956_o(), this.minPos.func_177952_p());
        } else if (pos.func_177958_n() > this.maxPos.func_177958_n()) {
            this.maxPos = new BlockPos(pos.func_177958_n(), this.maxPos.func_177956_o(), this.maxPos.func_177952_p());
        }
        if (pos.func_177956_o() < this.minPos.func_177956_o()) {
            this.minPos = new BlockPos(this.minPos.func_177958_n(), pos.func_177956_o(), this.minPos.func_177952_p());
        } else if (pos.func_177956_o() > this.maxPos.func_177956_o()) {
            this.maxPos = new BlockPos(this.maxPos.func_177958_n(), pos.func_177956_o(), this.maxPos.func_177952_p());
        }
        if (pos.func_177952_p() < this.minPos.func_177952_p()) {
            this.minPos = new BlockPos(this.minPos.func_177958_n(), this.minPos.func_177956_o(), pos.func_177952_p());
        } else if (pos.func_177952_p() > this.maxPos.func_177952_p()) {
            this.maxPos = new BlockPos(this.maxPos.func_177958_n(), this.maxPos.func_177956_o(), pos.func_177952_p());
        }
    }

    private void calculateCostForNewComponent(MultiBlockComponent comp) {
        ItemStack[] materials = comp.getMaterials();
        if (materials != null) {
            for (ItemStack stack : materials) {
                this.addStack(stack);
            }
        }
    }

    private void addStack(ItemStack stack) {
        if (stack == null) {
            return;
        }
        for (ItemStack oStack : this.materials) {
            if (!oStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)oStack, (ItemStack)stack)) continue;
            oStack.func_190917_f(stack.func_190916_E());
            return;
        }
        this.materials.add(stack);
    }

    public void setRenderOffset(BlockPos pos) {
        this.offPos = pos;
    }

    public List<MultiBlockComponent> getComponents() {
        return this.components;
    }

    public void rotate(double angle) {
        for (MultiBlockComponent comp : this.getComponents()) {
            comp.rotate(angle);
        }
        this.updateLocationCache();
    }

    public MultiBlock copy() {
        MultiBlock mb = new MultiBlock();
        for (MultiBlockComponent comp : this.getComponents()) {
            mb.addComponent(comp.copy());
        }
        return mb;
    }

    public Map<EnumFacing, MultiBlock> createRotations() {
        EnumMap<EnumFacing, MultiBlock> ret = new EnumMap<EnumFacing, MultiBlock>(EnumFacing.class);
        ret.put(EnumFacing.SOUTH, this);
        ret.put(EnumFacing.WEST, ((MultiBlock)ret.get(EnumFacing.SOUTH)).copy());
        ((MultiBlock)ret.get(EnumFacing.WEST)).rotate(1.5707963267948966);
        ret.put(EnumFacing.NORTH, ((MultiBlock)ret.get(EnumFacing.WEST)).copy());
        ((MultiBlock)ret.get(EnumFacing.NORTH)).rotate(1.5707963267948966);
        ret.put(EnumFacing.EAST, ((MultiBlock)ret.get(EnumFacing.NORTH)).copy());
        ((MultiBlock)ret.get(EnumFacing.EAST)).rotate(1.5707963267948966);
        return ret;
    }

    public MultiBlockSet makeSet() {
        return new MultiBlockSet(this);
    }

    public int getXSize() {
        return Math.abs(this.minPos.func_177958_n()) + Math.abs(this.maxPos.func_177958_n()) + 1;
    }

    public int getYSize() {
        return Math.abs(this.minPos.func_177956_o()) + Math.abs(this.maxPos.func_177956_o()) + 1;
    }

    public int getZSize() {
        return Math.abs(this.minPos.func_177952_p()) + Math.abs(this.maxPos.func_177952_p()) + 1;
    }

    public void updateLocationCache() {
        this.locationCache.clear();
        for (MultiBlockComponent comp : this.components) {
            this.addComponentToLocationCache(comp);
        }
    }

    private void addComponentToLocationCache(MultiBlockComponent comp) {
        BlockPos pos = comp.getRelativePosition();
        this.locationCache.put(pos, comp);
    }

    public MultiBlockComponent getComponentForLocation(BlockPos pos) {
        return this.locationCache.get(pos);
    }
}

