/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.blocks.multiblock;

import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiBlockComponent {
    protected BlockPos relPos;
    protected final IBlockState state;
    protected final TileEntity tileEntity;
    private final boolean doFancyRender;

    public MultiBlockComponent(BlockPos relPos, IBlockState state) {
        this(relPos, state, null);
    }

    public MultiBlockComponent(BlockPos relPos, IBlockState state, boolean doFancyRender) {
        this(relPos, state, doFancyRender, null);
    }

    public MultiBlockComponent(BlockPos relPos, IBlockState state, TileEntity tileEntity) {
        this(relPos, state, state.func_177230_c().hasTileEntity(state) == (tileEntity != null), tileEntity);
    }

    public MultiBlockComponent(BlockPos relPos, IBlockState state, boolean doFancyRender, TileEntity tileEntity) {
        this.relPos = relPos;
        this.state = state;
        this.tileEntity = tileEntity;
        this.doFancyRender = doFancyRender;
    }

    public BlockPos getRelativePosition() {
        return this.relPos;
    }

    public IBlockState getBlockState() {
        return this.state;
    }

    public boolean matches(World world, BlockPos pos) {
        return world.func_180495_p(pos) == this.state;
    }

    public ItemStack[] getMaterials() {
        return new ItemStack[]{new ItemStack(this.state.func_177230_c(), 1, this.state.func_177230_c().func_176201_c(this.state))};
    }

    public void rotate(double angle) {
        double x = this.relPos.func_177958_n();
        double z = this.relPos.func_177952_p();
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        double xn = x * cos - z * sin;
        double zn = x * sin + z * cos;
        this.relPos = new BlockPos((int)Math.round(xn), this.relPos.func_177956_o(), (int)Math.round(zn));
    }

    public MultiBlockComponent copy() {
        return new MultiBlockComponent(this.relPos, this.state, this.tileEntity);
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldDoFancyRender() {
        return this.doFancyRender;
    }
}

