/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.items.base;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.ARPConfig;
import net.thedragonteam.armorplus.ArmorPlus;
import net.thedragonteam.armorplus.items.BattleAxes;
import net.thedragonteam.armorplus.items.base.IItemHelper;
import net.thedragonteam.armorplus.util.PotionUtils;
import net.thedragonteam.armorplus.util.Utils;
import net.thedragonteam.thedragonlib.util.TextHelper;

public class BaseBattleAxe
extends ItemSword
implements IItemHelper {
    public static Item.ToolMaterial battleAxeCoalMaterial = EnumHelper.addToolMaterial((String)"battleAxeCoalMaterial", (int)1, (int)ARPConfig.coalBattleAxeDurability, (float)1.0f, (float)((float)ARPConfig.coalBattleAxeDamage), (int)15);
    public static Item.ToolMaterial battleAxeLapisMaterial = EnumHelper.addToolMaterial((String)"battleAxeLapisMaterial", (int)1, (int)ARPConfig.lapisBattleAxeDurability, (float)1.0f, (float)((float)ARPConfig.lapisBattleAxeDamage), (int)30);
    public static Item.ToolMaterial battleAxeRedstoneMaterial = EnumHelper.addToolMaterial((String)"battleAxeRedstoneMaterial", (int)1, (int)ARPConfig.redstoneBattleAxeDurability, (float)1.0f, (float)((float)ARPConfig.redstoneBattleAxeDamage), (int)20);
    public static Item.ToolMaterial battleAxeEmeraldMaterial = EnumHelper.addToolMaterial((String)"battleAxeEmeraldMaterial", (int)1, (int)ARPConfig.emeraldBattleAxeDurability, (float)1.0f, (float)((float)ARPConfig.emeraldBattleAxeDamage), (int)20);
    public static Item.ToolMaterial battleAxeObsidianMaterial = EnumHelper.addToolMaterial((String)"battleAxeObsidianMaterial", (int)1, (int)ARPConfig.obsidianBattleAxeDurability, (float)1.0f, (float)((float)ARPConfig.obsidianBattleAxeDamage), (int)20);
    public static Item.ToolMaterial battleAxeLavaMaterial = EnumHelper.addToolMaterial((String)"battleAxeLavaMaterial", (int)1, (int)ARPConfig.lavaBattleAxeDurability, (float)1.0f, (float)((float)ARPConfig.lavaBattleAxeDamage), (int)20);
    public static Item.ToolMaterial battleAxeGuardianMaterial = EnumHelper.addToolMaterial((String)"battleAxeGuardianMaterial", (int)1, (int)ARPConfig.guardianBattleAxeDurability, (float)1.0f, (float)((float)ARPConfig.guardianBattleAxeDamage), (int)30);
    public static Item.ToolMaterial battleAxeSuperStarMaterial = EnumHelper.addToolMaterial((String)"battleAxeSuperStarMaterial", (int)1, (int)ARPConfig.superStarBattleAxeDurability, (float)1.0f, (float)((float)ARPConfig.superStarBattleAxeDamage), (int)20);
    public static Item.ToolMaterial battleAxeEnderDragonMaterial = EnumHelper.addToolMaterial((String)"battleAxeEnderDragonMaterial", (int)1, (int)ARPConfig.enderDragonBattleAxeDurability, (float)1.0f, (float)((float)ARPConfig.enderDragonBattleAxeDamage), (int)20);
    public Item itemEasy;
    public Item itemExpert;
    public TextFormatting formatting;
    public String effect;
    public BattleAxes battleAxes;
    public float efficiency;

    public BaseBattleAxe(BattleAxes battleAxes) {
        super(battleAxes.getToolMaterial());
        this.func_77627_a(true);
        this.battleAxes = battleAxes;
        this.itemEasy = battleAxes.getRepairEasy();
        this.itemExpert = battleAxes.getRepairExpert();
        this.formatting = battleAxes.getTextFormatting();
        this.effect = battleAxes.getEffect();
        this.efficiency = battleAxes.getEfficiency();
        this.setRegistryName(battleAxes.func_176610_l() + "_battle_axe");
        this.func_77655_b(Utils.setName(battleAxes.func_176610_l() + "_battle_axe"));
        GameRegistry.register((IForgeRegistryEntry)this);
        this.func_77637_a(ArmorPlus.tabArmorplusWeapons);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Material material = state.func_185904_a();
        return material != Material.field_151575_d && material != Material.field_151585_k && material != Material.field_151582_l ? super.func_150893_a(stack, state) : this.battleAxes.getEfficiency();
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        switch (this.battleAxes) {
            case COAL: {
                if (!ARPConfig.enableCoalWeaponsEffects) break;
                PotionUtils.addEffect(target, PotionUtils.getPotion(ARPConfig.coalWeaponsAddPotionEffect), 180, ARPConfig.coalWeaponsEffectLevel, 'B');
                break;
            }
            case LAPIS: {
                if (!ARPConfig.enableLapisWeaponsEffects) break;
                PotionUtils.addEffect(target, PotionUtils.getPotion(ARPConfig.lapisWeaponsAddPotionEffect), ARPConfig.lapisWeaponsEffectLevel, 'B');
                break;
            }
            case REDSTONE: {
                if (!ARPConfig.enableRedstoneWeaponsEffects) break;
                PotionUtils.addEffect(target, PotionUtils.getPotion(ARPConfig.redstoneWeaponsAddPotionEffect), 180, ARPConfig.redstoneWeaponsEffectLevel, 'B');
                break;
            }
            case EMERALD: {
                if (!ARPConfig.enableEmeraldWeaponsEffects) break;
                PotionUtils.addEffect(target, PotionUtils.getPotion(ARPConfig.emeraldWeaponsAddPotionEffect), ARPConfig.emeraldWeaponsEffectLevel, 'B');
                break;
            }
            case OBSIDIAN: {
                if (!ARPConfig.enableObsidianWeaponsEffects) break;
                PotionUtils.addEffect(target, PotionUtils.getPotion(ARPConfig.obsidianWeaponsAddPotionEffect), ARPConfig.obsidianWeaponsEffectLevel, 'B');
                break;
            }
            case LAVA: {
                target.func_70015_d(8);
                break;
            }
            case GUARDIAN: {
                if (!ARPConfig.enableGuardianWeaponsEffects) break;
                PotionUtils.addEffect(target, PotionUtils.getPotion(ARPConfig.guardianWeaponsAddPotionEffect), ARPConfig.guardianWeaponsEffectLevel, 'B');
                break;
            }
            case SUPER_STAR: {
                if (!ARPConfig.enableSuperStarWeaponsEffects) break;
                PotionUtils.addEffect(target, PotionUtils.getPotion(ARPConfig.superStarWeaponsAddPotionEffect), ARPConfig.superStarWeaponsEffectLevel, 'B');
                break;
            }
            case ENDER_DRAGON: {
                if (!ARPConfig.enableEnderDragonWeaponsEffects) break;
                PotionUtils.addEffect(target, PotionUtils.getPotion(ARPConfig.enderDragonWeaponsAddPotionEffect), 60, ARPConfig.enderDragonWeaponsEffectLevel, 'B');
            }
        }
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
            tooltip.add("\u00a79Ability: \u00a7rApplies " + this.effect);
            tooltip.add("\u00a73Use: \u00a7rHit a Target");
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.tesla.showinfo", (Object[])new Object[]{this.formatting, keyBindSneak.getDisplayName(), TextFormatting.GRAY}));
        }
    }

    public String func_77653_i(ItemStack stack) {
        return (this.formatting + TextHelper.localize((String)(this.func_77657_g(stack) + ".name"), (Object[])new Object[0])).trim();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        switch (ARPConfig.recipes) {
            case 0: {
                return repair.func_77973_b() == this.itemEasy;
            }
            case 1: {
                return repair.func_77973_b() == this.itemExpert;
            }
        }
        return true;
    }

    @Override
    public void getItemStack(ItemStack stack) {
    }

    @Override
    public void getItem(Item item) {
    }

    @Override
    public ItemStack getItemStack() {
        return new ItemStack((Item)this);
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

