/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.items.base.energy.tesla;

import java.util.Set;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import net.thedragonteam.armorplus.ARPConfig;
import net.thedragonteam.armorplus.ArmorPlus;
import net.thedragonteam.armorplus.base.BaseARPTeslaContainerProvider;
import net.thedragonteam.armorplus.items.base.BaseSword;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.armorplus.util.ARPTeslaUtils;

public class BaseTeslaSword
extends BaseSword {
    private int maxCapacity;
    private int output;
    private int input;

    public BaseTeslaSword(Item.ToolMaterial material, String name, Set<Block> effectiveOn, int maxCapacity, int input, int output) {
        super(material, name, ModItems.steelIngot, ModItems.steelIngot, TextFormatting.func_96300_b((String)ARPConfig.teslaWeaponItemNameColor), null);
        this.func_77637_a(ArmorPlus.tabArmorplusTesla);
        this.func_77625_d(1);
        this.maxCapacity = maxCapacity;
        this.output = output;
        this.input = input;
    }

    public BaseTeslaSword(Item.ToolMaterial material, String name, int maxCapacity, int input, int output) {
        this(material, name, null, maxCapacity, input, output);
        this.func_77637_a(ArmorPlus.tabArmorplusTesla);
        this.func_77625_d(1);
        this.maxCapacity = maxCapacity;
        this.output = output;
        this.input = input;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    @Optional.Method(modid="tesla")
    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        ItemStack powered = ARPTeslaUtils.createChargedStack(new ItemStack(itemIn));
        ItemStack unpowered = new ItemStack(itemIn);
        subItems.add((Object)powered);
        subItems.add((Object)unpowered);
    }

    public boolean isRepairable() {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 30;
    }

    @Optional.Method(modid="tesla")
    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)ARPTeslaUtils.getStoredPower(stack) / (double)ARPTeslaUtils.getMaxCapacity(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Optional.Method(modid="tesla")
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new BaseARPTeslaContainerProvider(new BaseTeslaContainer(), this.maxCapacity, this.output, this.input);
    }
}

