/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.items.energy.tesla;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.thedragonteam.armorplus.ARPConfig;
import net.thedragonteam.armorplus.ArmorPlus;
import net.thedragonteam.armorplus.items.base.energy.tesla.BaseTeslaAxe;
import net.thedragonteam.armorplus.util.ARPTeslaUtils;

public class ItemTeslaAxe
extends BaseTeslaAxe {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150376_bx, Blocks.field_150373_bw, Blocks.field_150486_ae, Blocks.field_150468_ap, Blocks.field_150462_ai, Blocks.field_150415_aT, Blocks.field_180405_aT, Blocks.field_180404_aQ, Blocks.field_180406_aS, Blocks.field_180403_aR, Blocks.field_180407_aO, Blocks.field_180408_aP, Blocks.field_180387_bt, Blocks.field_180392_bq, Blocks.field_180385_bs, Blocks.field_180386_br, Blocks.field_180390_bo, Blocks.field_180391_bp, Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150342_X, Blocks.field_185766_cS, Blocks.field_185765_cR, Blocks.field_150323_B, Blocks.field_150423_aK, Blocks.field_150440_ba, Blocks.field_150344_f, Blocks.field_150452_aw, Blocks.field_150400_ck, Blocks.field_150487_bG, Blocks.field_150485_bF, Blocks.field_150401_cl, Blocks.field_150481_bH, Blocks.field_150476_ad});

    public ItemTeslaAxe() {
        super(Item.ToolMaterial.DIAMOND, "tesla_axe", EFFECTIVE_ON, ARPConfig.maxCapacityAxe, ARPConfig.inputAxe, ARPConfig.outputAxe);
    }

    public CreativeTabs func_77640_w() {
        return ArmorPlus.tabArmorplusTesla;
    }

    @Optional.Method(modid="tesla")
    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        ARPTeslaUtils.usePower(stack, ARPConfig.outputAxe);
        return true;
    }

    public boolean func_150897_b(IBlockState state) {
        return Items.field_151056_x.func_150897_b(state);
    }

    @Optional.Method(modid="tesla")
    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (ARPTeslaUtils.getStoredPower(stack) < (long)ARPConfig.outputAxe) {
            return 0.5f;
        }
        return Items.field_151053_p.func_150893_a(stack, state) > 1.0f ? 5.5f : super.func_150893_a(stack, state);
    }

    @Optional.Method(modid="tesla")
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        this.createTooltip(stack, tooltip);
    }

    @Optional.Method(modid="tesla")
    private void createTooltip(ItemStack stack, List<String> tooltip) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
            tooltip.add(TextFormatting.DARK_AQUA + I18n.func_135052_a((String)"tooltip.tesla.powerinfo", (Object[])new Object[]{Long.toString(ARPTeslaUtils.getStoredPower(stack)), Long.toString(ARPTeslaUtils.getMaxCapacity(stack))}));
            tooltip.add(TextFormatting.DARK_AQUA + I18n.func_135052_a((String)"tooltip.tesla.cost.tool", (Object[])new Object[]{Long.toString(ARPConfig.outputAxe)}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.tesla.showinfo", (Object[])new Object[]{TextFormatting.DARK_AQUA, keyBindSneak.getDisplayName(), TextFormatting.GRAY}));
        }
    }
}

