/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.thedragonteam.armorplus.misc.RenderCosmetics;
import net.thedragonteam.armorplus.misc.ThreadCosmeticsFetcher;

public class CosmeticsRenderInit {
    public static final HashMap<String, RenderCosmetics> COSMETICS_FOR_PEOPLE_LIST = new HashMap();

    public CosmeticsRenderInit() {
        new ThreadCosmeticsFetcher();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void parse(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            int meta;
            String[] values = properties.getProperty(key).split("@");
            if (values.length <= 0) continue;
            String itemName = values[0];
            try {
                meta = Integer.parseInt(values[1]);
            }
            catch (Exception e) {
                meta = 0;
            }
            ItemStack stack = null;
            ResourceLocation resLoc = new ResourceLocation(itemName);
            if (Item.field_150901_e.func_148741_d((Object)resLoc)) {
                stack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)resLoc), 1, meta);
            } else if (Block.field_149771_c.func_148741_d((Object)resLoc)) {
                stack = new ItemStack((Block)Block.field_149771_c.func_82594_a((Object)resLoc), 1, meta);
            }
            if (stack == null) continue;
            COSMETICS_FOR_PEOPLE_LIST.put(key, new RenderCosmetics(stack));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        if (!COSMETICS_FOR_PEOPLE_LIST.isEmpty()) {
            for (Map.Entry<String, RenderCosmetics> entry : COSMETICS_FOR_PEOPLE_LIST.entrySet()) {
                String playerName = event.getEntityPlayer().func_70005_c_();
                if (entry.getKey() == null || !entry.getKey().equalsIgnoreCase(playerName)) continue;
                entry.getValue().render(event.getEntityPlayer(), event.getPartialRenderTick());
                break;
            }
        }
    }
}

