/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.util;

import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

public class ARPTeslaUtils {
    @Optional.Method(modid="tesla")
    public static boolean isPoweredItem(ItemStack stack) {
        return stack.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, EnumFacing.DOWN);
    }

    @Optional.Method(modid="tesla")
    public static long getStoredPower(ItemStack stack) {
        if (ARPTeslaUtils.isPoweredItem(stack)) {
            BaseTeslaContainer container = ARPTeslaUtils.getContainer(stack);
            return ARPTeslaUtils.getContainer(stack).getStoredPower();
        }
        return 0L;
    }

    @Optional.Method(modid="tesla")
    public static long getMaxCapacity(ItemStack stack) {
        return ARPTeslaUtils.isPoweredItem(stack) ? ARPTeslaUtils.getContainer(stack).getCapacity() : 0L;
    }

    @Optional.Method(modid="tesla")
    public static void addPower(ItemStack stack, long amount) {
        if (ARPTeslaUtils.isPoweredItem(stack)) {
            ARPTeslaUtils.getContainer(stack).givePower(amount, false);
        }
    }

    @Optional.Method(modid="tesla")
    public static BaseTeslaContainer getContainer(ItemStack stack) {
        return ARPTeslaUtils.isPoweredItem(stack) ? (BaseTeslaContainer)stack.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, EnumFacing.DOWN) : null;
    }

    @Optional.Method(modid="tesla")
    public static void setMaxCapacity(ItemStack stack, long amount) {
        if (ARPTeslaUtils.isPoweredItem(stack)) {
            ARPTeslaUtils.getContainer(stack).setCapacity(amount);
        }
    }

    @Optional.Method(modid="tesla")
    public static void usePower(ItemStack stack, long amount) {
        if (ARPTeslaUtils.isPoweredItem(stack)) {
            ARPTeslaUtils.getContainer(stack).takePower(amount, false);
        }
    }

    @Optional.Method(modid="tesla")
    public static long getMaxInput(ItemStack stack) {
        return ARPTeslaUtils.isPoweredItem(stack) ? ARPTeslaUtils.getContainer(stack).getInputRate() : 0L;
    }

    @Optional.Method(modid="tesla")
    public static long getMaxOutput(ItemStack stack) {
        return ARPTeslaUtils.isPoweredItem(stack) ? ARPTeslaUtils.getContainer(stack).getOutputRate() : 0L;
    }

    @Optional.Method(modid="tesla")
    public static ItemStack createChargedStack(ItemStack stack) {
        if (ARPTeslaUtils.isPoweredItem(stack)) {
            ItemStack chargedstack = stack.func_77946_l();
            ARPTeslaUtils.getContainer(chargedstack).setInputRate(ARPTeslaUtils.getMaxCapacity(stack));
            ARPTeslaUtils.addPower(chargedstack, ARPTeslaUtils.getMaxCapacity(stack));
            ARPTeslaUtils.getContainer(chargedstack).setInputRate(ARPTeslaUtils.getMaxInput(stack));
            return chargedstack;
        }
        return null;
    }

    @Optional.Method(modid="tesla")
    public static boolean isTelsaBlock(TileEntity tileEntity) {
        return tileEntity.hasCapability(TeslaCapabilities.CAPABILITY_HOLDER, EnumFacing.DOWN);
    }

    @Optional.Method(modid="tesla")
    public static BaseTeslaContainer getContainer(TileEntity tileEntity) {
        if (ARPTeslaUtils.isTelsaBlock(tileEntity)) {
            BaseTeslaContainer container = (BaseTeslaContainer)tileEntity.getCapability(TeslaCapabilities.CAPABILITY_HOLDER, EnumFacing.DOWN);
            return container;
        }
        return null;
    }

    @Optional.Method(modid="tesla")
    public static boolean isConsumer(TileEntity tileEntity) {
        return tileEntity.hasCapability(TeslaCapabilities.CAPABILITY_CONSUMER, EnumFacing.DOWN);
    }

    @Optional.Method(modid="tesla")
    public static long getMaxCapacity(TileEntity tile) {
        return ARPTeslaUtils.getContainer(tile).getCapacity();
    }

    @Optional.Method(modid="tesla")
    public static long getStoredPower(TileEntity tile) {
        return ARPTeslaUtils.getContainer(tile).getStoredPower();
    }

    @Optional.Method(modid="tesla")
    public static long getMissingPower(TileEntity tileEntity) {
        return ARPTeslaUtils.getMaxCapacity(tileEntity) - ARPTeslaUtils.getStoredPower(tileEntity);
    }

    @Optional.Method(modid="tesla")
    public static boolean canAcceptPower(TileEntity tile, long amount) {
        return ARPTeslaUtils.getMissingPower(tile) >= amount;
    }

    @Optional.Method(modid="tesla")
    public static void addPower(TileEntity tileEntity, long amount) {
        ARPTeslaUtils.getContainer(tileEntity).givePower(amount, false);
    }
}

