/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.worldgen;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.thedragonteam.armorplus.ARPConfig;
import net.thedragonteam.armorplus.registry.ModBlocks;

public class OreGen
implements IWorldGenerator {
    private WorldGenerator lavaCrystalOverworldGenerator = new WorldGenMinable(ModBlocks.blockLavaCrystal.func_176223_P(), ARPConfig.lavaCrystalOverworldVeinAmount);
    private WorldGenerator lavaCrystalTheEndGenerator = new WorldGenMinable(ModBlocks.blockLavaCrystal.func_176223_P(), ARPConfig.lavaCrystalTheEndVeinAmount, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
    private WorldGenerator lavaCrystalTheNetherGenerator = new WorldGenMinable(ModBlocks.blockLavaCrystal.func_176223_P(), ARPConfig.lavaCrystalTheNetherVeinAmount, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                if (!ARPConfig.enableLavaCrystalOverworldGen) break;
                this.runGenerator(this.lavaCrystalOverworldGenerator, world, random, chunkX, chunkZ, ARPConfig.lavaCrystalOverworldRarity, ARPConfig.lavaCrystalOverworldMinYSpawn, ARPConfig.lavaCrystalOverworldMaxYSpawn);
                break;
            }
            case 1: {
                if (!ARPConfig.enableLavaCrystalTheEndGen) break;
                this.runGenerator(this.lavaCrystalTheEndGenerator, world, random, chunkX, chunkZ, ARPConfig.lavaCrystalTheEndRarity, ARPConfig.lavaCrystalTheEndMinYSpawn, ARPConfig.lavaCrystalTheEndMaxYSpawn);
                break;
            }
            case -1: {
                if (!ARPConfig.enableLavaCrystalTheNetherGen) break;
                this.runGenerator(this.lavaCrystalTheNetherGenerator, world, random, chunkX, chunkZ, ARPConfig.lavaCrystalTheNetherRarity, ARPConfig.lavaCrystalTheNetherMinYSpawn, ARPConfig.lavaCrystalTheNetherMaxYSpawn);
            }
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z * 16 + rand.nextInt(16);
            generator.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }
}

