/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.thedragonteam.thedragonlib.blocks.TileDLBase;
import net.thedragonteam.thedragonlib.lib.Vec3I;
import net.thedragonteam.thedragonlib.network.MessageHandlerWrapper;

public class PacketSyncableObject
implements IMessage {
    public static final byte BOOLEAN_INDEX = 0;
    public static final byte BYTE_INDEX = 1;
    public static final byte INT_INDEX = 2;
    public static final byte DOUBLE_INDEX = 3;
    public static final byte FLOAT_INDEX = 4;
    public static final byte STRING_INDEX = 5;
    public static final byte TAG_INDEX = 6;
    public static final byte VEC3I_INDEX = 7;
    public static final byte LONG_INDEX = 8;
    public static final byte SHORT_INDEX = 9;
    public BlockPos tilePos;
    public byte index;
    public String stringValue = "";
    public float floatValue = 0.0f;
    public double doubleValue = 0.0;
    public int intValue = 0;
    public short shortValue = 0;
    public byte byteValue = 0;
    public boolean booleanValue = false;
    public NBTTagCompound compound;
    public Vec3I vec3I;
    public long longValue;
    public boolean updateOnReceived;
    public byte dataType;

    public PacketSyncableObject() {
    }

    public PacketSyncableObject(TileDLBase tile, byte syncableIndex, boolean booleanValue, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.index = syncableIndex;
        this.booleanValue = booleanValue;
        this.dataType = 0;
    }

    public PacketSyncableObject(TileDLBase tile, byte syncableIndex, byte byteValue, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.index = syncableIndex;
        this.byteValue = byteValue;
        this.dataType = 1;
    }

    public PacketSyncableObject(TileDLBase tile, byte syncableIndex, short shortValue, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.index = syncableIndex;
        this.shortValue = shortValue;
        this.dataType = (byte)9;
    }

    public PacketSyncableObject(TileDLBase tile, byte syncableIndex, int intValue, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.index = syncableIndex;
        this.intValue = intValue;
        this.dataType = (byte)2;
    }

    public PacketSyncableObject(TileDLBase tile, byte syncableIndex, double doubleValue, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.index = syncableIndex;
        this.doubleValue = doubleValue;
        this.dataType = (byte)3;
    }

    public PacketSyncableObject(TileDLBase tile, byte syncableIndex, float floatValue, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.index = syncableIndex;
        this.floatValue = floatValue;
        this.dataType = (byte)4;
    }

    public PacketSyncableObject(TileDLBase tile, byte syncableIndex, String stringValue, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.index = syncableIndex;
        this.stringValue = stringValue;
        this.dataType = (byte)5;
    }

    public PacketSyncableObject(TileDLBase tile, byte syncableIndex, NBTTagCompound compound, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.index = syncableIndex;
        this.compound = compound;
        this.dataType = (byte)6;
    }

    public PacketSyncableObject(TileDLBase tile, byte syncableIndex, Vec3I vec3I, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.index = syncableIndex;
        this.vec3I = vec3I;
        this.dataType = (byte)7;
    }

    public PacketSyncableObject(TileDLBase tile, byte syncableIndex, long longValue, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.index = syncableIndex;
        this.longValue = longValue;
        this.dataType = (byte)8;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.dataType);
        buf.writeByte((int)this.index);
        buf.writeInt(this.tilePos.func_177958_n());
        buf.writeInt(this.tilePos.func_177956_o());
        buf.writeInt(this.tilePos.func_177952_p());
        switch (this.dataType) {
            case 0: {
                buf.writeBoolean(this.booleanValue);
                break;
            }
            case 1: {
                buf.writeByte((int)this.byteValue);
                break;
            }
            case 2: {
                buf.writeInt(this.intValue);
                break;
            }
            case 3: {
                buf.writeDouble(this.doubleValue);
                break;
            }
            case 4: {
                buf.writeFloat(this.floatValue);
                break;
            }
            case 5: {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.stringValue);
                break;
            }
            case 6: {
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.compound);
                break;
            }
            case 7: {
                buf.writeInt(this.vec3I.x);
                buf.writeInt(this.vec3I.y);
                buf.writeInt(this.vec3I.z);
                break;
            }
            case 8: {
                buf.writeLong(this.longValue);
                break;
            }
            case 9: {
                buf.writeShort((int)this.shortValue);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.dataType = buf.readByte();
        this.index = buf.readByte();
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.tilePos = new BlockPos(x, y, z);
        switch (this.dataType) {
            case 0: {
                this.booleanValue = buf.readBoolean();
                break;
            }
            case 1: {
                this.byteValue = buf.readByte();
                break;
            }
            case 2: {
                this.intValue = buf.readInt();
                break;
            }
            case 3: {
                this.doubleValue = buf.readDouble();
                break;
            }
            case 4: {
                this.floatValue = buf.readFloat();
                break;
            }
            case 5: {
                this.stringValue = ByteBufUtils.readUTF8String((ByteBuf)buf);
                break;
            }
            case 6: {
                this.compound = ByteBufUtils.readTag((ByteBuf)buf);
                break;
            }
            case 7: {
                this.vec3I = new Vec3I(0, 0, 0);
                this.vec3I.x = buf.readInt();
                this.vec3I.y = buf.readInt();
                this.vec3I.z = buf.readInt();
                break;
            }
            case 8: {
                this.longValue = buf.readLong();
                break;
            }
            case 9: {
                this.shortValue = buf.readShort();
            }
        }
    }

    public static class Handler
    extends MessageHandlerWrapper<PacketSyncableObject, IMessage> {
        @Override
        public IMessage handleMessage(PacketSyncableObject message, MessageContext ctx) {
            TileEntity tile;
            if (ctx.side == Side.CLIENT && (tile = FMLClientHandler.instance().getWorldClient().func_175625_s(message.tilePos)) instanceof TileDLBase) {
                ((TileDLBase)tile).receiveSyncPacketFromServer(message);
            }
            return null;
        }
    }
}

