/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.wrappers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.thedragonteam.thedragonlib.TheDragonLib;
import net.thedragonteam.thedragonlib.blocks.TileDLBase;
import net.thedragonteam.thedragonlib.network.PacketSyncableObject;
import net.thedragonteam.thedragonlib.util.LogHelper;
import net.thedragonteam.thedragonlib.wrappers.SyncableObject;

public class SyncableInt
extends SyncableObject {
    public int value;
    private int lastTickValue;

    public SyncableInt(int value, boolean syncInTile, boolean syncInContainer, boolean updateOnReceived) {
        super(syncInTile, syncInContainer, updateOnReceived);
        this.value = this.lastTickValue = value;
    }

    public SyncableInt(int value, boolean syncInTile, boolean syncInContainer) {
        super(syncInTile, syncInContainer);
        this.value = this.lastTickValue = value;
    }

    @Override
    public void detectAndSendChanges(TileDLBase tile, EntityPlayer player, boolean forceSync) {
        if (this.lastTickValue != this.value || forceSync) {
            this.lastTickValue = this.value;
            tile.dirtyBlock();
            if (player == null) {
                TheDragonLib.network.sendToAllAround((IMessage)new PacketSyncableObject(tile, this.index, this.value, this.updateOnReceived), tile.syncRange());
            } else if (player instanceof EntityPlayerMP) {
                TheDragonLib.network.sendTo((IMessage)new PacketSyncableObject(tile, this.index, this.value, this.updateOnReceived), (EntityPlayerMP)player);
            } else {
                LogHelper.error("SyncableInt#detectAndSendChanges No valid destination for sync packet!");
            }
        }
    }

    @Override
    public void updateReceived(PacketSyncableObject packet) {
        if (packet.dataType == 2) {
            this.value = packet.intValue;
        }
    }

    @Override
    public void toNBT(NBTTagCompound compound) {
        compound.func_74768_a("SyncableInt" + this.index, this.value);
    }

    @Override
    public void fromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("SyncableInt" + this.index)) {
            this.value = compound.func_74762_e("SyncableInt" + this.index);
        }
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

