/*
 * Decompiled with CFR 0.152.
 */
package rocks.sakira.flamingo.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import rocks.sakira.flamingo.entity.goals.DeepSwimGoal;
import rocks.sakira.flamingo.register.Entities;
import rocks.sakira.flamingo.register.Items;
import rocks.sakira.flamingo.register.SoundEvents;

public class EntityFlamingo
extends AnimalEntity {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)Items.SHRIMP.get()});
    private static final DataParameter<Boolean> LEG_UP_STATE = EntityDataManager.func_187226_a(EntityFlamingo.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int timeUntilNextEgg;

    public EntityFlamingo(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
        this.timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 6000;
        this.field_70138_W = 1.6f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LEG_UP_STATE, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 0.4));
        this.field_70714_bg.func_75776_a(1, (Goal)new TemptGoal((CreatureEntity)this, 0.4, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 0.3));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(6, (Goal)new DeepSwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowParentGoal((AnimalEntity)this, 0.4));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, EntityFlamingo.class, 6.0f));
    }

    public boolean func_70877_b(@Nonnull ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        EntitySize size = super.func_213305_a(poseIn);
        return this.func_70631_g_() ? size.func_220313_a(1.33f) : size;
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return (AgeableEntity)((EntityType)Entities.FLAMINGO_ENTITY.get()).func_200721_a(this.field_70170_p);
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return this.func_70631_g_() ? 1.15f : 1.75f;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.func_70631_g_() && --this.timeUntilNextEgg <= 0) {
            this.func_184185_a(net.minecraft.util.SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_199703_a((IItemProvider)Items.FLAMINGO_EGG.get());
            this.timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 6000;
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("EggLayTime")) {
            this.timeUntilNextEgg = compound.func_74762_e("EggLayTime");
        }
        if (compound.func_74764_b("LegUpState")) {
            this.field_70180_af.func_187227_b(LEG_UP_STATE, (Object)compound.func_74767_n("LegUpState"));
        }
    }

    public boolean isOneLegged() {
        return (Boolean)this.field_70180_af.func_187225_a(LEG_UP_STATE);
    }

    public void setOneLegged(boolean state) {
        this.field_70180_af.func_187227_b(LEG_UP_STATE, (Object)state);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("EggLayTime", this.timeUntilNextEgg);
        compound.func_74757_a("LegUpState", ((Boolean)this.field_70180_af.func_187225_a(LEG_UP_STATE)).booleanValue());
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)Items.FLAMINGO_SPAWN_EGG.get());
    }

    public SoundEvent func_184639_G() {
        if (this.func_70631_g_()) {
            return (SoundEvent)SoundEvents.BABY_FLAMINGO_AMBIENT_SOUND.get();
        }
        return (SoundEvent)SoundEvents.FLAMINGO_AMBIENT_SOUND.get();
    }
}

