/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.registry;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.blazekrew.variant16x.registry.BlockRegistry;
import net.blazekrew.variant16x.registry.ConfigRegistry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeRegistry {
    public static void registerBiomes() {
        if (ConfigRegistry.isEnabled(ConfigRegistry.ENABLE_MISCELLANEOUS)) {
            for (Biome biome : ForgeRegistries.BIOMES) {
                if (ConfigRegistry.isEnabled(ConfigRegistry.ENABLE_INFESTED_STONES) && (biome == Biomes.field_185443_S || biome == Biomes.field_185434_af || biome == Biomes.field_76783_v || biome == Biomes.field_76770_e || biome == Biomes.field_150580_W)) {
                    BiomeRegistry.registerInfestedAndesiteDioriteAndGranite(biome, 2);
                }
                if (!ConfigRegistry.isEnabled(ConfigRegistry.ENABLE_SMALL_FLOWERS)) continue;
                if (biome == Biomes.field_150583_P || biome == Biomes.field_150582_Q || biome == Biomes.field_150585_R || biome == Biomes.field_185430_ab || biome == Biomes.field_76767_f || biome == Biomes.field_185448_Z || biome == Biomes.field_185429_aa || biome == Biomes.field_76785_t) {
                    BiomeRegistry.registerPaeoniaRoseAndSyringa(biome, 1);
                }
                if (biome == Biomes.field_185444_T) {
                    BiomeRegistry.registerPaeoniaRoseAndSyringa(biome, 8);
                }
                if (biome != Biomes.field_185441_Q) continue;
                BiomeRegistry.registerSmallSunflower(biome, 9);
            }
        }
    }

    public static void registerInfestedAndesiteDioriteAndGranite(Biome biome, int count) {
        BiomeRegistry.registerInfestedAndesite(biome, count);
        BiomeRegistry.registerInfestedDiorite(biome, count);
        BiomeRegistry.registerInfestedGranite(biome, count);
    }

    public static void registerInfestedAndesite(Biome biome, int count) {
        ConfiguredFeature INFESTED_ANDESITE_CONFIG = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, BlockRegistry.INFESTED_ANDESITE.func_176223_P(), 7));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, INFESTED_ANDESITE_CONFIG.func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(count, 0, 0, 64))));
    }

    public static void registerInfestedDiorite(Biome biome, int count) {
        ConfiguredFeature INFESTED_DIORITE_CONFIG = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, BlockRegistry.INFESTED_DIORITE.func_176223_P(), 7));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, INFESTED_DIORITE_CONFIG.func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(count, 0, 0, 64))));
    }

    public static void registerInfestedGranite(Biome biome, int count) {
        ConfiguredFeature INFESTED_GRANITE_CONFIG = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, BlockRegistry.INFESTED_GRANITE.func_176223_P(), 7));
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, INFESTED_GRANITE_CONFIG.func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(count, 0, 0, 64))));
    }

    public static void registerPaeoniaRoseAndSyringa(Biome biome, int count) {
        BiomeRegistry.registerPaeonia(biome, count);
        BiomeRegistry.registerRose(biome, count);
        BiomeRegistry.registerSyringa(biome, count);
    }

    public static void registerPaeonia(Biome biome, int count) {
        ConfiguredFeature PAEONIA_CONFIG = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.PAEONIA.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_());
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202291_ak.func_225566_b_((IFeatureConfig)new MultipleWithChanceRandomFeatureConfig((List)ImmutableList.of((Object)PAEONIA_CONFIG), 0)).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(count))));
    }

    public static void registerRose(Biome biome, int count) {
        ConfiguredFeature ROSE_CONFIG = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.ROSE.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_());
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202291_ak.func_225566_b_((IFeatureConfig)new MultipleWithChanceRandomFeatureConfig((List)ImmutableList.of((Object)ROSE_CONFIG), 0)).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(count))));
    }

    public static void registerSyringa(Biome biome, int count) {
        ConfiguredFeature SYRINGA_CONFIG = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.SYRINGA.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_());
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202291_ak.func_225566_b_((IFeatureConfig)new MultipleWithChanceRandomFeatureConfig((List)ImmutableList.of((Object)SYRINGA_CONFIG), 0)).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(count))));
    }

    public static void registerSmallSunflower(Biome biome, int count) {
        ConfiguredFeature SMALL_SUNFLOWER_CONFIG = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BlockRegistry.SMALL_SUNFLOWER.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_());
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202291_ak.func_225566_b_((IFeatureConfig)new MultipleWithChanceRandomFeatureConfig((List)ImmutableList.of((Object)SMALL_SUNFLOWER_CONFIG), 0)).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(count))));
    }
}

