/*
 * Decompiled with CFR 0.152.
 */
package io.github.cyberanner.ironchests.client;

import io.github.cyberanner.ironchests.blocks.GenericChestBlock;
import io.github.cyberanner.ironchests.blocks.blockentities.CrystalChestEntity;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_4732;
import net.minecraft.class_4737;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_809;
import net.minecraft.class_826;

@Environment(value=EnvType.CLIENT)
public class ChestEntityRenderer<T extends class_2595>
extends class_826<T> {
    private final class_630 chestLid;
    private final class_630 chestBottom;
    private final class_630 chestLock;

    public ChestEntityRenderer(class_5614.class_5615 context) {
        super(context);
        class_630 modelPart = context.method_32140(class_5602.field_27689);
        this.chestLid = modelPart.method_32086("lid");
        this.chestBottom = modelPart.method_32086("bottom");
        this.chestLock = modelPart.method_32086("lock");
    }

    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 world = entity.method_10997();
        class_2680 blockState = world != null ? entity.method_11010() : (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.field_11035);
        class_2248 block = blockState.method_26204();
        if (block instanceof GenericChestBlock) {
            GenericChestBlock chest = (GenericChestBlock)block;
            matrices.method_22903();
            float rotation = ((class_2350)blockState.method_11654((class_2769)class_2281.field_10768)).method_10144();
            matrices.method_22904(0.5, 0.5, 0.5);
            matrices.method_22907(class_1160.field_20705.method_23214(-rotation));
            matrices.method_22904(-0.5, -0.5, -0.5);
            class_4732.class_4734 properties = world == null ? class_4732.class_3923::method_24174 : chest.method_24167(blockState, world, entity.method_11016(), true);
            float g = ((Float2FloatFunction)properties.apply(GenericChestBlock.method_24166(entity))).get(tickDelta);
            g = 1.0f - g;
            g = 1.0f - g * g * g;
            int i = ((Int2IntFunction)properties.apply((class_4732.class_3923)new class_4737())).applyAsInt(light);
            class_4730 spriteIdentifier = new class_4730(class_4722.field_21709, chest.getType().texture);
            class_4588 vertexConsumer = spriteIdentifier.method_24145(vertexConsumers, class_1921::method_23576);
            ChestEntityRenderer.renderMatrices(matrices, vertexConsumer, this.chestLid, this.chestLock, this.chestBottom, g, i, overlay);
            if (entity instanceof CrystalChestEntity) {
                this.renderItems(matrices, (CrystalChestEntity)((Object)entity), tickDelta, vertexConsumers, light, overlay);
            }
            matrices.method_22909();
        }
    }

    private void renderItems(class_4587 matrices, CrystalChestEntity chestEntity, float tickDelta, class_4597 vertexConsumers, int light, int overlay) {
        int j;
        class_2371<class_1799> inv = chestEntity.method_11282();
        int counter = 0;
        for (j = 0; j < 3; ++j) {
            this.renderItem(0.55, 0.3 + (double)j * 0.5, 0.7, inv, counter, matrices, chestEntity, tickDelta, vertexConsumers, light, overlay);
            ++counter;
        }
        for (j = 0; j < 3; ++j) {
            this.renderItem(1.4, 0.3 + (double)j * 0.5, 0.7, inv, counter, matrices, chestEntity, tickDelta, vertexConsumers, light, overlay);
            ++counter;
        }
        for (j = 0; j < 3; ++j) {
            this.renderItem(0.55, 0.3 + (double)j * 0.5, 1.4, inv, counter, matrices, chestEntity, tickDelta, vertexConsumers, light, overlay);
            ++counter;
        }
        for (j = 0; j < 3; ++j) {
            this.renderItem(1.4, 0.3 + (double)j * 0.5, 1.4, inv, counter, matrices, chestEntity, tickDelta, vertexConsumers, light, overlay);
            ++counter;
        }
    }

    private void renderItem(double x, double y, double z, class_2371<class_1799> inv, int counter, class_4587 matrices, CrystalChestEntity chestEntity, float tickDelta, class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22909();
        matrices.method_22903();
        class_1799 item = (class_1799)inv.get(counter);
        matrices.method_22905(0.5f, 0.5f, 0.5f);
        matrices.method_22904(x, y, z);
        matrices.method_22907(class_1160.field_20705.method_23214((float)chestEntity.method_10997().method_8510() + tickDelta));
        class_310.method_1551().method_1480().method_23178(item, class_809.class_811.field_4318, light, overlay, matrices, vertexConsumers, 0);
    }

    private static void renderMatrices(class_4587 matrices, class_4588 vertices, class_630 lid, class_630 latch, class_630 base, float openFactor, int light, int overlay) {
        latch.field_3654 = lid.field_3654 = -openFactor * 1.5707964f;
        lid.method_22698(matrices, vertices, light, overlay);
        latch.method_22698(matrices, vertices, light, overlay);
        base.method_22698(matrices, vertices, light, overlay);
    }
}

