/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.SignedBytes;
import cpw.mods.ironchest.BlockIronChest;
import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.TileEntityIronChest;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderEntityItem;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TileEntityIronChestRenderer<T extends TileEntityIronChest>
extends TileEntitySpecialRenderer<T> {
    private static Map<IronChestType, ResourceLocation> locations;
    private Random random;
    private RenderEntityItem itemRenderer;
    private ModelChest model = new ModelChest();
    private static float[][] shifts;

    public TileEntityIronChestRenderer(Class<T> type) {
        this.random = new Random();
        this.itemRenderer = new RenderEntityItem(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()){

            public int func_177078_a(ItemStack stack) {
                return SignedBytes.saturatedCast((long)(Math.min(stack.field_77994_a / 32, 15) + 1));
            }

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
    }

    public void render(TileEntityIronChest tile, double x, double y, double z, float partialTick, int breakStage) {
        if (tile == null) {
            return;
        }
        int facing = 3;
        IronChestType type = tile.getType();
        if (tile != null && tile.func_145830_o() && tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177230_c() == IronChest.ironChestBlock) {
            facing = tile.getFacing();
            type = tile.getType();
            IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
            type = (IronChestType)((Object)state.func_177229_b(BlockIronChest.VARIANT_PROP));
        }
        if (breakStage >= 0) {
            this.func_147499_a(field_178460_a[breakStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            this.func_147499_a(locations.get((Object)type));
        }
        GlStateManager.func_179094_E();
        if (type == IronChestType.CRYSTAL) {
            GlStateManager.func_179129_p();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        int k = 0;
        if (facing == 2) {
            k = 180;
        }
        if (facing == 3) {
            k = 0;
        }
        if (facing == 4) {
            k = 90;
        }
        if (facing == 5) {
            k = -90;
        }
        GlStateManager.func_179114_b((float)k, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float lidangle = tile.prevLidAngle + (tile.lidAngle - tile.prevLidAngle) * partialTick;
        lidangle = 1.0f - lidangle;
        lidangle = 1.0f - lidangle * lidangle * lidangle;
        this.model.field_78234_a.field_78795_f = -(lidangle * 3.141593f / 2.0f);
        this.model.func_78231_a();
        if (breakStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
        if (type == IronChestType.CRYSTAL) {
            GlStateManager.func_179089_o();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (type.isTransparent() && tile.func_145835_a(this.field_147501_a.field_147560_j, this.field_147501_a.field_147561_k, this.field_147501_a.field_147558_l) < 128.0) {
            this.random.setSeed(254L);
            int shift = 0;
            float blockScale = 0.7f;
            float timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
            if (tile.getTopItemStacks()[1] == null) {
                shift = 8;
                blockScale = 0.85f;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            EntityItem customitem = new EntityItem(this.func_178459_a());
            customitem.field_70290_d = 0.0f;
            for (ItemStack item : tile.getTopItemStacks()) {
                if (shift > shifts.length) break;
                if (item == null) {
                    ++shift;
                    continue;
                }
                float shiftX = shifts[shift][0];
                float shiftY = shifts[shift][1];
                float shiftZ = shifts[shift][2];
                ++shift;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)shiftX, (float)shiftY, (float)shiftZ);
                GlStateManager.func_179114_b((float)timeD, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)blockScale, (float)blockScale, (float)blockScale);
                customitem.func_92058_a(item);
                this.itemRenderer.func_76986_a(customitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
    }

    public void renderTileEntityAt(TileEntityIronChest tileentity, double x, double y, double z, float partialTick, int breakStage) {
        this.render(tileentity, x, y, z, partialTick, breakStage);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (IronChestType typ : IronChestType.values()) {
            builder.put((Object)typ, (Object)new ResourceLocation("ironchest", "textures/model/" + typ.getModelTexture()));
        }
        locations = builder.build();
        shifts = new float[][]{{0.3f, 0.45f, 0.3f}, {0.7f, 0.45f, 0.3f}, {0.3f, 0.45f, 0.7f}, {0.7f, 0.45f, 0.7f}, {0.3f, 0.1f, 0.3f}, {0.7f, 0.1f, 0.3f}, {0.3f, 0.1f, 0.7f}, {0.7f, 0.1f, 0.7f}, {0.5f, 0.32f, 0.5f}};
    }
}

