/*
 * Decompiled with CFR 0.152.
 */
package terrails.stattinkerer.fabric;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import terrails.stattinkerer.CStatTinkerer;
import terrails.stattinkerer.api.STMobEffects;
import terrails.stattinkerer.config.ConfigOption;
import terrails.stattinkerer.fabric.EventHandler;
import terrails.stattinkerer.fabric.mobeffect.NoAppetiteMobEffect;
import terrails.stattinkerer.feature.ExperienceFeature;
import terrails.stattinkerer.feature.HungerFeature;
import terrails.stattinkerer.feature.health.HealthFeature;

public class StatTinkerer
implements ModInitializer {
    public static CommentedFileConfig FILE_CONFIG;

    public void onInitialize() {
        STMobEffects.NO_APPETITE = NoAppetiteMobEffect.registerEffect();
        StatTinkerer.setupConfig();
        StatTinkerer.registerEvents();
    }

    private static void setupConfig() {
        String fileName = "stattinkerer.toml";
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path configPath = configDir.resolve("stattinkerer.toml");
        ConfigSpec spec = new ConfigSpec();
        for (Object object : CStatTinkerer.CONFIGURATION_INSTANCES) {
            for (Field field : object.getClass().getDeclaredFields()) {
                try {
                    field.setAccessible(true);
                    Object object2 = field.get(object);
                    if (!(object2 instanceof ConfigOption)) continue;
                    ConfigOption option = (ConfigOption)object2;
                    spec.define(option.getPath(), option.getDefault(), option.getOptionValidator());
                }
                catch (IllegalAccessException | SecurityException | InaccessibleObjectException e) {
                    CStatTinkerer.LOGGER.error("Could not process spec for {} in {}", (Object)field.getName(), (Object)object.getClass().getName());
                    e.printStackTrace();
                }
            }
        }
        while (true) {
            CStatTinkerer.LOGGER.debug("Initializing {} config file", (Object)"stattinkerer.toml");
            CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().autoreload().onFileNotFound(FileNotFoundAction.CREATE_EMPTY).writingMode(WritingMode.REPLACE).build();
            try {
                CStatTinkerer.LOGGER.info("Loading {} config file", (Object)"stattinkerer.toml");
                config.load();
                while (!spec.isCorrect((Config)config)) {
                    int correction = spec.correct((Config)config, (action, path, incorrectValue, correctedValue) -> {
                        String pathString = String.join((CharSequence)".", path);
                        switch (action) {
                            case ADD: {
                                CStatTinkerer.LOGGER.info("Missing entry {} = {} added to {}", (Object)pathString, correctedValue, (Object)"stattinkerer.toml");
                                break;
                            }
                            case REMOVE: {
                                CStatTinkerer.LOGGER.info("Invalid entry {} removed from {}", (Object)pathString, (Object)"stattinkerer.toml");
                                break;
                            }
                            case REPLACE: {
                                CStatTinkerer.LOGGER.info("Invalid entry {}: value {} replaced by {} in {}", (Object)pathString, incorrectValue, correctedValue, (Object)"stattinkerer.toml");
                            }
                        }
                    });
                    CStatTinkerer.LOGGER.info("{} correction(s) applied to {} config file", (Object)correction, (Object)"stattinkerer.toml");
                    config.save();
                }
                for (Object object : CStatTinkerer.CONFIGURATION_INSTANCES) {
                    for (Field field : object.getClass().getDeclaredFields()) {
                        try {
                            ConfigOption option;
                            field.setAccessible(true);
                            Object object3 = field.get(object);
                            if (!(object3 instanceof ConfigOption) || !spec.isDefined((option = (ConfigOption)object3).getPath())) continue;
                            Object comment = option.getComment().isEmpty() ? "" : option.getComment() + "\n";
                            Object t = option.getDefault();
                            if (t instanceof List) {
                                List list = (List)t;
                                if (!list.isEmpty()) {
                                    Object element = list.get(0);
                                    String listStr = element instanceof Number ? list.stream().map(Object::toString).collect(Collectors.joining(", ")) : list.stream().map(o -> "\"" + o.toString() + "\"").collect(Collectors.joining(", "));
                                    comment = (String)comment + "Default: [ %s ]".formatted(listStr);
                                }
                            } else {
                                comment = (String)comment + "Default: %s".formatted(option.getDefault().toString());
                            }
                            config.setComment(option.getPath(), (String)comment);
                            option.initialize(() -> config.get(option.getPath()), val -> config.set(option.getPath(), val));
                        }
                        catch (IllegalAccessException | SecurityException | InaccessibleObjectException e) {
                            CStatTinkerer.LOGGER.error("Could not process value for {} in {}", (Object)field.getName(), (Object)object.getClass().getName());
                            e.printStackTrace();
                        }
                    }
                }
                config.save();
                FILE_CONFIG = config;
                CStatTinkerer.LOGGER.info("Successfully loaded {} config file", (Object)"stattinkerer.toml");
                break;
            }
            catch (ParsingException e) {
                config.close();
                CStatTinkerer.LOGGER.error("Failed to load '{}' due to a parsing error.", (Object)"stattinkerer.toml");
                e.printStackTrace();
                String deformedFile = "stattinkerer-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss")) + ".toml";
                try {
                    Files.move(configPath, configDir.resolve(deformedFile), new CopyOption[0]);
                    CStatTinkerer.LOGGER.error("Deformed config file renamed to '{}'", (Object)deformedFile);
                }
                catch (IOException ee) {
                    CStatTinkerer.LOGGER.error("Moving deformed config file failed...");
                    ee.printStackTrace();
                    throw new RuntimeException("Could not initialize '%s' config file.".formatted("stattinkerer.toml"));
                }
            }
        }
    }

    private static void registerEvents() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> HealthFeature.INSTANCE.onPlayerJoinServer(handler.field_14140));
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            ExperienceFeature.INSTANCE.onPlayerClone(!alive, newPlayer, oldPlayer);
            HungerFeature.INSTANCE.onPlayerClone(!alive, newPlayer, oldPlayer);
            HealthFeature.INSTANCE.onPlayerClone(!alive, newPlayer, oldPlayer);
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (!alive) {
                HungerFeature.INSTANCE.onPlayerRespawn(newPlayer);
            }
        });
        EventHandler.ITEM_INTERACTION_USE.register((Object)HungerFeature.INSTANCE);
        EventHandler.ITEM_INTERACTION_USE.register((Object)HealthFeature.INSTANCE);
        EventHandler.ITEM_INTERACTION_COMPLETED.register((Object)HealthFeature.INSTANCE);
        EventHandler.BLOCK_INTERACTION.register((Object)HungerFeature.INSTANCE);
        EventHandler.EXPERIENCE_DROP.register((Object)ExperienceFeature.INSTANCE);
    }
}

