/*
 * Decompiled with CFR 0.152.
 */
package terrails.stattinkerer.feature.health;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4174;
import terrails.stattinkerer.CStatTinkerer;
import terrails.stattinkerer.LoaderExpectPlatform;
import terrails.stattinkerer.api.health.HealthManager;
import terrails.stattinkerer.config.Configuration;
import terrails.stattinkerer.feature.event.ItemInteractionEvents;
import terrails.stattinkerer.feature.event.PlayerStateEvents;
import terrails.stattinkerer.feature.health.HealthHelper;

public class HealthFeature
implements PlayerStateEvents.JoinServer,
PlayerStateEvents.Clone,
ItemInteractionEvents.Use,
ItemInteractionEvents.Completed {
    public static final HealthFeature INSTANCE = new HealthFeature();

    @Override
    public void onPlayerJoinServer(class_3222 player) {
        if (Configuration.HEALTH.systemEnabled.get().booleanValue()) {
            LoaderExpectPlatform.getHealthManager(player).ifPresent(manager -> manager.update(player));
        } else {
            HealthHelper.removeModifier((class_1657)player);
        }
    }

    @Override
    public void onPlayerClone(boolean wasDeath, class_3222 newPlayer, class_3222 oldPlayer) {
        Optional<HealthManager> optional;
        if (!wasDeath) {
            return;
        }
        if (Configuration.HEALTH.systemEnabled.get().booleanValue() && (optional = LoaderExpectPlatform.getHealthManager(newPlayer)).isPresent()) {
            HealthManager manager = optional.get();
            LoaderExpectPlatform.reviveInvalidateForgeCapability((class_1657)oldPlayer, true);
            LoaderExpectPlatform.getHealthManager(oldPlayer).ifPresent(oldManager -> {
                class_2487 tag = new class_2487();
                oldManager.serialize(tag);
                manager.deserialize(tag);
                manager.setHealth(newPlayer, manager.getHealth());
            });
            LoaderExpectPlatform.reviveInvalidateForgeCapability((class_1657)oldPlayer, false);
            if (Objects.equals(Configuration.HEALTH.startingHealth.get(), Configuration.HEALTH.maxHealth.get()) && Configuration.HEALTH.minHealth.get() == 0 && !Configuration.HEALTH.hardcoreMode.get().booleanValue()) {
                manager.update(newPlayer);
            } else {
                int decrease = Configuration.HEALTH.decreasedOnDeath.get();
                if (!oldPlayer.method_7337() && !oldPlayer.method_7325() && decrease > 0 && manager.isHealthRemovable()) {
                    int prevHealth = manager.getHealth();
                    manager.addHealth(newPlayer, -decrease);
                    newPlayer.method_6033((float)manager.getHealth());
                    double removedAmount = manager.getHealth() - prevHealth;
                    if (Configuration.HEALTH.healthChangeMessage.get().booleanValue() && removedAmount > 0.0) {
                        HealthHelper.playerMessage((class_1657)newPlayer, "health.stattinkerer.death_remove", removedAmount);
                    }
                    if (Configuration.HEALTH.hardcoreMode.get().booleanValue() && manager.getHealth() <= 0) {
                        manager.reset(newPlayer);
                        newPlayer.method_7336(class_1934.field_9219);
                    }
                }
            }
        }
        if (Configuration.HEALTH.respawnAmount.get() != 0) {
            newPlayer.method_6033((float)Configuration.HEALTH.respawnAmount.get().intValue());
        }
    }

    @Override
    public class_1271<class_1799> onItemUseInteraction(class_1937 level, class_1657 _player, class_1799 stack, class_1268 hand) {
        class_3222 player;
        class_1271 result = class_1271.method_22430((Object)class_1799.field_8037);
        if (Configuration.HEALTH.systemEnabled.get().booleanValue() && _player instanceof class_3222 && !(player = (class_3222)_player).method_7337() && !player.method_7325()) {
            if (player.method_5715() && Configuration.HEALTH.regenerativeItemsConsumptionMode.get() == Configuration.RegenerativeItemsConsumptionMode.NOT_CROUCHING) {
                return result;
            }
            if (!player.method_5715() && Configuration.HEALTH.regenerativeItemsConsumptionMode.get() == Configuration.RegenerativeItemsConsumptionMode.CROUCHING) {
                return result;
            }
            Optional<HealthManager> optional = LoaderExpectPlatform.getHealthManager(player);
            if (optional.isPresent()) {
                HealthManager manager = optional.get();
                class_4174 food = stack.method_7909().method_19264();
                if (food != null && player.method_7332(food.method_19233())) {
                    return result;
                }
                if (stack.method_7976() == class_1839.field_8946) {
                    return result;
                }
                for (String itemString : Configuration.HEALTH.regenerativeItems.get()) {
                    boolean bypass;
                    Matcher matcher = CStatTinkerer.REGENERATIVE_ITEM_REGEX.matcher(itemString);
                    if (!matcher.find()) continue;
                    class_2960 regName = new class_2960(matcher.group(1));
                    if (!Objects.equals(LoaderExpectPlatform.getItemRegistryName(stack.method_7909()), regName)) continue;
                    int amount = Integer.parseInt(matcher.group(2));
                    if (!manager.addHealth(player, amount, bypass = itemString.endsWith(":"))) break;
                    class_1799 resultStack = stack.method_7972();
                    resultStack.method_7934(1);
                    result = class_1271.method_22427((Object)resultStack);
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public class_1271<class_1799> onItemUseInteractionCompleted(class_1937 level, class_1657 _player, class_1799 startStack, class_1799 endStack) {
        class_3222 player;
        class_1271 result = class_1271.method_22430((Object)class_1799.field_8037);
        if (Configuration.HEALTH.systemEnabled.get().booleanValue() && _player instanceof class_3222 && !(player = (class_3222)_player).method_7337() && !player.method_7325()) {
            for (String itemString : Configuration.HEALTH.regenerativeItems.get()) {
                Matcher matcher = CStatTinkerer.REGENERATIVE_ITEM_REGEX.matcher(itemString);
                if (!matcher.find()) continue;
                class_2960 regName = new class_2960(matcher.group(1));
                if (!Objects.equals(LoaderExpectPlatform.getItemRegistryName(startStack.method_7909()), regName)) continue;
                int amount = Integer.parseInt(matcher.group(2));
                boolean bypass = itemString.endsWith(":");
                LoaderExpectPlatform.getHealthManager(player).ifPresent(manager -> manager.addHealth(player, amount, bypass));
                if (!class_1799.method_7973((class_1799)startStack, (class_1799)endStack)) break;
                class_1799 resultStack = endStack.method_7972();
                resultStack.method_7934(1);
                return class_1271.method_22427((Object)resultStack);
            }
        }
        return result;
    }
}

