/*
 * Decompiled with CFR 0.152.
 */
package terrails.stattinkerer.feature.health;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import terrails.stattinkerer.api.health.HealthManager;
import terrails.stattinkerer.config.Configuration;
import terrails.stattinkerer.feature.health.HealthHelper;

public class HealthManagerImpl
implements HealthManager {
    private int amount = 0;
    private int threshold = 0;
    private int start = 0;
    private int max = 0;
    private int min = 0;

    @Override
    public void update(class_3222 playerEntity) {
        Integer nearestThreshold;
        if (!Configuration.HEALTH.systemEnabled.get().booleanValue()) {
            return;
        }
        if (this.hasConfigChanged()) {
            this.reset(playerEntity);
            return;
        }
        int prevThreshold = this.threshold;
        int prevHealthAmount = this.amount;
        if (!HealthHelper.hasModifier((class_1657)playerEntity)) {
            this.amount = this.start;
        }
        int n = (nearestThreshold = (Integer)ImmutableSortedSet.copyOf((Collection)Configuration.HEALTH.thresholds.get()).floor((Object)this.amount)) != null ? (Math.abs(nearestThreshold) <= this.amount ? Math.abs(nearestThreshold) : nearestThreshold) : (this.threshold = 0);
        if (this.start == this.max && this.min <= 0 && !Configuration.HEALTH.hardcoreMode.get().booleanValue()) {
            this.amount = this.max;
        } else {
            int min = Math.max(this.min, this.threshold);
            this.amount = class_3532.method_15340((int)this.amount, (int)min, (int)this.max);
        }
        if (prevHealthAmount != this.amount) {
            this.setHealth(playerEntity, this.amount);
        }
        if (prevThreshold != this.threshold && prevThreshold != 0 && this.threshold > 0) {
            HealthHelper.playerMessage((class_1657)playerEntity, "health.stattinkerer.threshold", Math.abs(this.threshold));
        }
    }

    @Override
    public boolean setHealth(class_3222 playerEntity, int amount) {
        if (!Configuration.HEALTH.systemEnabled.get().booleanValue()) {
            return false;
        }
        if (this.amount != (amount = class_3532.method_15340((int)amount, (int)this.min, (int)this.max)) || amount != class_3532.method_15375((float)playerEntity.method_6063())) {
            HealthHelper.addModifier((class_1657)playerEntity, amount);
            if (playerEntity.method_6032() > playerEntity.method_6063()) {
                playerEntity.method_6033(playerEntity.method_6063());
            } else {
                playerEntity.method_6033(playerEntity.method_6032() + (float)Math.max(amount - this.amount, 0));
            }
            this.amount = amount;
            this.update(playerEntity);
            return true;
        }
        return false;
    }

    @Override
    public boolean addHealth(class_3222 playerEntity, int amount) {
        return this.addHealth(playerEntity, amount, true);
    }

    @Override
    public boolean addHealth(class_3222 playerEntity, int amount, boolean threshold) {
        if (!Configuration.HEALTH.systemEnabled.get().booleanValue()) {
            return false;
        }
        int prevThreshold = this.threshold;
        int prevHealth = this.amount;
        int min = Math.max(this.min, threshold ? this.threshold : 0);
        if (this.amount == (amount = class_3532.method_15340((int)(this.amount + amount), (int)min, (int)this.max))) {
            return false;
        }
        boolean ret = this.setHealth(playerEntity, amount);
        if (ret && prevThreshold == this.threshold) {
            String key = this.amount - prevHealth > 0 ? "health.stattinkerer.item_add" : "health.stattinkerer.item_lose";
            HealthHelper.playerMessage((class_1657)playerEntity, key, Math.abs(this.amount - prevHealth));
        }
        return ret;
    }

    @Override
    public void reset(class_3222 playerEntity) {
        this.threshold = 0;
        this.start = Configuration.HEALTH.startingHealth.get();
        this.max = Configuration.HEALTH.maxHealth.get();
        this.min = Configuration.HEALTH.minHealth.get();
        this.amount = (int)playerEntity.method_6063();
        this.setHealth(playerEntity, this.start);
    }

    @Override
    public int getHealth() {
        return this.amount;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public boolean isHighest() {
        return this.amount == this.max;
    }

    @Override
    public boolean isLowest() {
        return this.amount == this.min;
    }

    @Override
    public boolean isHealthRemovable() {
        int min = Math.max(this.min, Math.abs(this.threshold));
        return this.min > 0 && this.amount > min || Configuration.HEALTH.hardcoreMode.get() != false;
    }

    @Override
    public void serialize(class_2487 tag) {
        tag.method_10569("stattinkerer:additional_health", this.amount - 20);
        tag.method_10569("stattinkerer:max_health", this.max);
        tag.method_10569("stattinkerer:min_health", this.min);
        tag.method_10569("stattinkerer:starting_health", this.start);
        tag.method_10569("stattinkerer:health_threshold", this.threshold);
    }

    @Override
    public void deserialize(class_2487 tag) {
        if (tag.method_10545("stattinkerer:starting_health")) {
            this.start = tag.method_10550("stattinkerer:starting_health");
        }
        if (tag.method_10545("stattinkerer:additional_health")) {
            this.amount = tag.method_10550("stattinkerer:additional_health") + 20;
        }
        if (tag.method_10545("stattinkerer:max_health")) {
            this.max = tag.method_10550("stattinkerer:max_health");
        }
        if (tag.method_10545("stattinkerer:min_health")) {
            this.min = tag.method_10550("stattinkerer:min_health");
        }
        if (tag.method_10545("stattinkerer:health_threshold")) {
            this.threshold = tag.method_10550("stattinkerer:health_threshold");
        }
    }

    private boolean hasConfigChanged() {
        for (String strValue : Configuration.HEALTH.onChangeReset.get()) {
            Configuration.OnChangeReset value = Configuration.OnChangeReset.NAME_MAP.get(strValue);
            switch (value) {
                case MIN_HEALTH: {
                    if (Configuration.HEALTH.minHealth.get() == this.min) break;
                    return true;
                }
                case MAX_HEALTH: {
                    if (Configuration.HEALTH.maxHealth.get() == this.max) break;
                    return true;
                }
                case STARTING_HEALTH: {
                    if (Configuration.HEALTH.startingHealth.get() == this.start) break;
                    return true;
                }
            }
        }
        return false;
    }
}

