/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.repurpose.Config;

import com.wuest.repurpose.Base.BaseConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class RedstoneClockPowerConfiguration
extends BaseConfig {
    private HashMap<EnumFacing, Boolean> facingPower = new HashMap();
    private int poweredTick = 20;
    private int unPoweredTick = 20;
    private BlockPos pos;

    public RedstoneClockPowerConfiguration() {
        for (EnumFacing facing : EnumFacing.values()) {
            this.facingPower.put(facing, true);
        }
    }

    public int getPoweredTick() {
        return this.poweredTick;
    }

    public void setPoweredTick(int value) {
        if (value <= 0) {
            value = 1;
        }
        this.poweredTick = value;
    }

    public int getUnPoweredTick() {
        return this.unPoweredTick;
    }

    public void setUnPoweredTick(int value) {
        if (value < 0) {
            value = 1;
        }
        this.unPoweredTick = value;
    }

    public boolean getSidePower(EnumFacing facing) {
        return this.facingPower.get(facing);
    }

    public ArrayList<EnumFacing> getPoweredSides() {
        ArrayList<EnumFacing> poweredFacings = new ArrayList<EnumFacing>();
        for (Map.Entry<EnumFacing, Boolean> facing : this.facingPower.entrySet()) {
            if (!facing.getValue().booleanValue()) continue;
            poweredFacings.add(facing.getKey());
        }
        return poweredFacings;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos value) {
        this.pos = value;
    }

    public void setSidePower(EnumFacing facing, boolean value) {
        this.facingPower.put(facing, value);
    }

    @Override
    public void WriteToNBTCompound(NBTTagCompound compound) {
        NBTTagCompound powerCompound = new NBTTagCompound();
        powerCompound.func_74768_a("poweredTick", this.poweredTick);
        powerCompound.func_74768_a("unPoweredTick", this.unPoweredTick);
        for (Map.Entry<EnumFacing, Boolean> entry : this.facingPower.entrySet()) {
            powerCompound.func_74757_a(entry.getKey().func_176742_j(), entry.getValue().booleanValue());
        }
        if (this.pos != null) {
            powerCompound.func_74768_a("x", this.pos.func_177958_n());
            powerCompound.func_74768_a("y", this.pos.func_177956_o());
            powerCompound.func_74768_a("z", this.pos.func_177952_p());
        }
        compound.func_74782_a("powerCompound", (NBTBase)powerCompound);
    }

    public RedstoneClockPowerConfiguration ReadFromNBTTagCompound(NBTTagCompound compound) {
        RedstoneClockPowerConfiguration configuration = new RedstoneClockPowerConfiguration();
        if (compound.func_74764_b("powerCompound")) {
            NBTTagCompound powerCompound = compound.func_74775_l("powerCompound");
            configuration.poweredTick = powerCompound.func_74762_e("poweredTick");
            configuration.unPoweredTick = powerCompound.func_74762_e("unPoweredTick");
            for (EnumFacing facing : EnumFacing.values()) {
                configuration.facingPower.put(facing, powerCompound.func_74767_n(facing.func_176742_j()));
            }
            if (powerCompound.func_74764_b("x")) {
                configuration.pos = new BlockPos(powerCompound.func_74762_e("x"), powerCompound.func_74762_e("y"), powerCompound.func_74762_e("z"));
            }
        }
        return configuration;
    }
}

