/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.repurpose.Proxy;

import com.wuest.repurpose.Blocks.BlockCoffer;
import com.wuest.repurpose.Blocks.BlockCustomWall;
import com.wuest.repurpose.Blocks.BlockGrassSlab;
import com.wuest.repurpose.Blocks.BlockGrassStairs;
import com.wuest.repurpose.Capabilities.ItemBagOfHoldingProvider;
import com.wuest.repurpose.Config.WuestConfiguration;
import com.wuest.repurpose.Events.ClientEventHandler;
import com.wuest.repurpose.Gui.GuiCoffer;
import com.wuest.repurpose.Gui.GuiItemBagOfHolding;
import com.wuest.repurpose.Gui.GuiRedstoneClock;
import com.wuest.repurpose.Gui.GuiRedstoneScanner;
import com.wuest.repurpose.Proxy.CommonProxy;
import com.wuest.repurpose.Renderer.TileEntityCofferRenderer;
import com.wuest.repurpose.Repurpose;
import com.wuest.repurpose.Tiles.TileEntityCoffer;
import com.wuest.repurpose.particle.MysteriousParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.IItemHandler;

public class ClientProxy
extends CommonProxy {
    public WuestConfiguration serverConfiguration = null;
    public static ClientEventHandler clientEventHandler = new ClientEventHandler();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        Repurpose.proxy.registerRenderers();
        this.RegisterEventListeners();
        this.RegisterKeyBindings();
    }

    @Override
    public void postinit(FMLPostInitializationEvent event) {
        super.postinit(event);
    }

    @Override
    public void registerRenderers() {
        BlockGrassStairs.RegisterBlockRenderer();
        BlockGrassSlab.RegisterBlockRenderer();
        BlockCustomWall.RegisterBlockRenderer();
        for (BlockCoffer.IronChestType type : BlockCoffer.IronChestType.values()) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCoffer.class, (TileEntitySpecialRenderer)new TileEntityCofferRenderer());
        }
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        System.out.println("Retrieving player from ClientProxy for message on side " + ctx.side);
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }

    @Override
    public IThreadListener getThreadFromContext(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x() : super.getThreadFromContext(ctx);
    }

    @Override
    public void generateParticles(EntityPlayer player) {
        double motionX = player.field_70170_p.field_73012_v.nextGaussian() * 0.02;
        double motionY = player.field_70170_p.field_73012_v.nextGaussian() * 0.02;
        double motionZ = player.field_70170_p.field_73012_v.nextGaussian() * 0.02;
        MysteriousParticle particleMysterious = new MysteriousParticle(player.field_70170_p, player.field_70165_t + (double)(player.field_70170_p.field_73012_v.nextFloat() * player.field_70130_N * 2.0f) - (double)player.field_70130_N, player.field_70163_u + 0.5 + (double)(player.field_70170_p.field_73012_v.nextFloat() * player.field_70131_O), player.field_70161_v + (double)(player.field_70170_p.field_73012_v.nextFloat() * player.field_70130_N * 2.0f) - (double)player.field_70130_N, motionX, motionY, motionZ);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particleMysterious);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
        if (ID == 5) {
            return new GuiRedstoneClock(x, y, z);
        }
        if (ID == 6) {
            return new GuiRedstoneScanner(x, y, z);
        }
        if (tileEntity != null && tileEntity instanceof TileEntityCoffer) {
            return GuiCoffer.GUI.buildGUI(((TileEntityCoffer)tileEntity).getType(), (IInventory)player.field_71071_by, (TileEntityCoffer)tileEntity);
        }
        if (ID == 8) {
            ItemStack stack = player.func_184592_cb();
            ItemBagOfHoldingProvider handler = ItemBagOfHoldingProvider.GetFromStack(stack);
            return new GuiItemBagOfHolding((IItemHandler)handler, player);
        }
        return null;
    }

    @Override
    public WuestConfiguration getServerConfiguration() {
        if (this.serverConfiguration == null) {
            return CommonProxy.proxyConfiguration;
        }
        return this.serverConfiguration;
    }

    private void RegisterEventListeners() {
        System.out.println("Registering event listeners");
        MinecraftForge.EVENT_BUS.register((Object)clientEventHandler);
    }

    private void RegisterKeyBindings() {
        KeyBinding binding = new KeyBinding("Previous Item", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.ALT, 44, "Repurpose - Bag of Holding");
        ClientEventHandler.keyBindings.add(binding);
        ClientRegistry.registerKeyBinding((KeyBinding)binding);
        binding = new KeyBinding("Next Item", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.ALT, 45, "Repurpose - Bag of Holding");
        ClientEventHandler.keyBindings.add(binding);
        ClientRegistry.registerKeyBinding((KeyBinding)binding);
    }
}

