/*
 * Decompiled with CFR 0.152.
 */
package me.geek.tom.lat.blockinfo;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.geek.tom.lat.blockinfo.api.BlockInformation;
import me.geek.tom.lat.blockinfo.api.IBlockInfoSupplier;
import me.geek.tom.lat.blockinfo.impl.BasicInformationSupplier;
import me.geek.tom.lat.blockinfo.impl.CapabilityInformationSupplier;
import me.geek.tom.lat.blockinfo.impl.ContainerInformationSupplier;
import me.geek.tom.lat.event.RegisterInfoSuppliersEvent;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.StringUtils;

public class InformationGatherer {
    private static final List<IBlockInfoSupplier> blockInfoSuppliers = new ArrayList<IBlockInfoSupplier>();

    private static void registerBlockInfoSupplier(IBlockInfoSupplier supplier) {
        if (!blockInfoSuppliers.contains(supplier)) {
            blockInfoSuppliers.add(supplier);
        }
    }

    public static void fireRegisterEvent() {
        blockInfoSuppliers.add(new BasicInformationSupplier());
        blockInfoSuppliers.add(new ContainerInformationSupplier());
        blockInfoSuppliers.add(new CapabilityInformationSupplier());
        MinecraftForge.EVENT_BUS.post((Event)new RegisterInfoSuppliersEvent(InformationGatherer::registerBlockInfoSupplier));
    }

    public static BlockInformation gatherInformation(World world, BlockPos pos, ServerPlayerEntity sender) {
        int toolLevel;
        BlockState state = world.func_180495_p(pos);
        ItemStack stack = sender.func_184614_ca();
        ToolType tool = state.getHarvestTool();
        boolean canHarvest = stack.func_190926_b() || tool == null ? state.func_185887_b((IBlockReader)world, pos) >= 0.0f : (toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, (PlayerEntity)sender, state)) >= state.getHarvestLevel();
        BlockInformation info = new BlockInformation(canHarvest);
        for (IBlockInfoSupplier supplier : blockInfoSuppliers) {
            if (!supplier.shouldHandle(pos, state, world)) continue;
            supplier.addInfo(info::addInformation, pos, state, world);
        }
        return info;
    }

    @Nullable
    public static String getModName(ItemStack itemStack) {
        Item item;
        String modId;
        if (!itemStack.func_190926_b() && (modId = (item = itemStack.func_77973_b()).getCreatorModId(itemStack)) != null) {
            return ModList.get().getModContainerById(modId).map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modId));
        }
        return null;
    }
}

