/*
 * Decompiled with CFR 0.152.
 */
package me.geek.tom.lat.blockinfo.api;

import com.google.common.collect.Lists;
import java.util.List;
import me.geek.tom.lat.blockinfo.api.BlockInfoLine;
import net.minecraft.network.PacketBuffer;

public class BlockInformation {
    private final List<BlockInfoLine> information = Lists.newArrayList();
    private final boolean canHarvest;

    public BlockInformation(boolean canHarvest) {
        this.canHarvest = canHarvest;
    }

    public void addInformation(BlockInfoLine info) {
        this.information.add(info);
    }

    public List<BlockInfoLine> getInformation() {
        return this.information;
    }

    public void serializeToPacket(PacketBuffer buf) {
        int len = this.information.size();
        buf.writeBoolean(this.canHarvest);
        buf.writeInt(len);
        for (BlockInfoLine ln : this.information) {
            buf.func_211400_a(ln.getLine(), Short.MAX_VALUE);
            buf.writeInt(ln.getColour());
        }
    }

    public boolean canHarvest() {
        return this.canHarvest;
    }

    public static BlockInformation fromPacket(PacketBuffer buf) {
        BlockInformation ret = new BlockInformation(buf.readBoolean());
        int len = buf.readInt();
        for (int i = 0; i < len; ++i) {
            ret.addInformation(new BlockInfoLine(buf.func_150789_c(Short.MAX_VALUE), buf.readInt()));
        }
        return ret;
    }
}

