/*
 * Decompiled with CFR 0.152.
 */
package me.geek.tom.lat.networking;

import java.util.function.Supplier;
import me.geek.tom.lat.modapi.CapabilityLATInfo;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateSignText {
    private final String message;
    private final BlockPos pos;
    private final RegistryKey<World> dimension;

    public PacketUpdateSignText(String message, BlockPos pos, RegistryKey<World> dimension) {
        this.message = message;
        this.pos = pos;
        this.dimension = dimension;
    }

    public PacketUpdateSignText(PacketBuffer buf) {
        this.message = buf.func_150789_c(Short.MAX_VALUE);
        this.pos = buf.func_179259_c();
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.message);
        buf.func_179255_a(this.pos);
        buf.func_192572_a(this.dimension.func_240901_a_());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerWorld world = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_73046_m().func_71218_a(this.dimension);
            TileEntity te = world.func_175625_s(this.pos);
            if (te == null) {
                throw new RuntimeException("No tileentity at the position recieved! This suggests that someone is messing with packets!");
            }
            te.getCapability(CapabilityLATInfo.LAT_INFO_CAPABILITY).ifPresent(handler -> handler.setMessage(this.message));
        });
    }
}

