/*
 * Decompiled with CFR 0.152.
 */
package me.geek.tom.lat.overlay;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nullable;
import me.geek.tom.lat.Config;
import me.geek.tom.lat.blockinfo.api.BlockInfoLine;
import me.geek.tom.lat.blockinfo.api.BlockInformation;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.StringUtils;

public class OverlayRenderer
extends Screen {
    private Item currentItem = Items.field_190931_a;
    public BlockInformation currentBlockInfo;

    public OverlayRenderer() {
        super((ITextComponent)new StringTextComponent(""));
    }

    public void setItem(Item item) {
        this.currentItem = item;
    }

    public Item getCurrentItem() {
        return this.currentItem;
    }

    public void render(MatrixStack stack) {
        if (this.currentBlockInfo == null) {
            return;
        }
        RenderSystem.pushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack itemStack = new ItemStack((IItemProvider)this.currentItem, 1);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int width = 0;
        List<BlockInfoLine> information = this.currentBlockInfo.getInformation();
        for (BlockInfoLine ln : information) {
            width = Math.max(width, mc.field_71466_p.func_78256_a(ln.getLine()));
        }
        width += 35;
        int height = 12 + 10 * information.size();
        if (information.size() == 1) {
            height += 10;
        }
        this.preconfigureRender(width);
        OverlayRenderer.func_238467_a_((MatrixStack)stack, (int)5, (int)5, (int)width, (int)height, (int)-2013265920);
        boolean canBreak = this.currentBlockInfo.canHarvest();
        if (!information.isEmpty()) {
            this.renderBox(stack, 5, 5, width - 5, height - 5, canBreak ? -16711936 : -65536);
        }
        this.renderItemStack(itemStack, 10, 10);
        int i = 0;
        for (BlockInfoLine line : information) {
            mc.field_71466_p.func_238421_b_(stack, line.getLine(), 30.0f, (float)(10 + i * 10), line.getColour());
            ++i;
        }
        RenderSystem.popMatrix();
    }

    private void renderBox(MatrixStack stack, int x, int y, int width, int height, int col) {
        this.line(stack, x, y, width, false, col);
        this.line(stack, x, y + height - 1, width, false, col);
        this.line(stack, x, y, height, true, col);
        this.line(stack, x + width - 1, y, height, true, col);
    }

    private void line(MatrixStack stack, int x, int y, int length, boolean vertical, int col) {
        if (vertical) {
            OverlayRenderer.func_238467_a_((MatrixStack)stack, (int)x, (int)y, (int)(x + 1), (int)(y + length), (int)col);
        } else {
            OverlayRenderer.func_238467_a_((MatrixStack)stack, (int)x, (int)y, (int)(x + length), (int)(y + 1), (int)col);
        }
    }

    private void renderItemStack(ItemStack itm, int x, int y) {
        ItemRenderer itemRender = Minecraft.func_71410_x().func_175599_af();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!itm.func_190926_b()) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)32.0f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableRescaleNormal();
            RenderSystem.enableLighting();
            int short1 = 240;
            int short2 = 240;
            RenderHelper.func_227784_d_();
            try {
                itemRender.func_180450_b(itm, x, y);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RenderSystem.popMatrix();
            RenderSystem.disableRescaleNormal();
            RenderSystem.disableLighting();
        }
    }

    private void preconfigureRender(int width) {
        if (((Boolean)Config.CENTER_HUD.get()).booleanValue()) {
            int screenWidth = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
            int screenCenterPosition = (screenWidth - 10) / 2;
            int translateToCenter = screenCenterPosition - width / 2;
            RenderSystem.translatef((float)translateToCenter, (float)0.0f, (float)0.0f);
        }
    }

    @Nullable
    private String getModName(Block block) {
        if (!block.equals(Blocks.field_150350_a)) {
            String modId = block.getRegistryName().func_110624_b();
            return ModList.get().getModContainerById(modId).map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modId));
        }
        return null;
    }
}

