/*
 * Decompiled with CFR 0.152.
 */
package com.xray;

import com.xray.Configuration;
import com.xray.keybinding.KeyBindings;
import com.xray.store.BlockStore;
import com.xray.store.GameBlockStore;
import com.xray.store.JsonStore;
import com.xray.utils.BlockData;
import com.xray.xray.Controller;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="xray")
@Mod.EventBusSubscriber(modid="xray")
@OnlyIn(value=Dist.CLIENT)
public class XRay {
    public static final String MOD_ID = "xray";
    public static final String PREFIX_GUI = "xray:textures/gui/";
    public static GameBlockStore gameBlockStore = new GameBlockStore();
    public static Minecraft mc = Minecraft.func_71410_x();
    public static JsonStore blockStore = new JsonStore();
    public static Logger logger = LogManager.getLogger();

    public XRay() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::onSetup);
        eventBus.addListener(this::onLoadComplete);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Configuration.SPEC);
        MinecraftForge.EVENT_BUS.addListener(this::onExit);
        MinecraftForge.EVENT_BUS.register(KeyBindings.class);
    }

    private void onSetup(FMLCommonSetupEvent event) {
        logger.debug(I18n.func_135052_a((String)"xray.debug.init", (Object[])new Object[0]));
        KeyBindings.setup();
        List<BlockData.SerializableBlockData> data = blockStore.read();
        if (data.isEmpty()) {
            return;
        }
        ArrayList<BlockData> map = BlockStore.getFromSimpleBlockList(data);
        Controller.getBlockStore().setStore(map);
    }

    private void onLoadComplete(FMLLoadCompleteEvent event) {
        gameBlockStore.populate();
    }

    private void onExit(FMLServerStoppingEvent event) {
        Controller.shutdownExecutor();
    }
}

