/*
 * Decompiled with CFR 0.152.
 */
package com.xray.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.xray.Configuration;
import com.xray.XRay;
import com.xray.gui.GuiHelp;
import com.xray.gui.manage.GuiAddBlock;
import com.xray.gui.manage.GuiBlockList;
import com.xray.gui.manage.GuiEdit;
import com.xray.gui.utils.GuiBase;
import com.xray.gui.utils.ScrollingList;
import com.xray.gui.utils.SupportButton;
import com.xray.store.BlockStore;
import com.xray.utils.BlockData;
import com.xray.xray.Controller;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;

public class GuiSelectionScreen
extends GuiBase {
    private static final ResourceLocation CIRCLE = new ResourceLocation("xray:textures/gui/circle.png");
    private Button distButtons;
    private TextFieldWidget search;
    public ItemRenderer render;
    private String lastSearch = "";
    private ArrayList<BlockData> itemList;
    private ArrayList<BlockData> originalList;
    private ScrollingBlockList scrollList;

    public GuiSelectionScreen() {
        super(true);
        this.setSideTitle(I18n.func_135052_a((String)"xray.single.tools", (Object[])new Object[0]));
        if (XRay.blockStore.created) {
            List<BlockData.SerializableBlockData> blocks = XRay.blockStore.populateDefault();
            Controller.getBlockStore().setStore(BlockStore.getFromSimpleBlockList(blocks));
            XRay.blockStore.created = false;
        }
        this.itemList = new ArrayList<BlockData>(Controller.getBlockStore().getStore().values());
        this.itemList.sort(Comparator.comparingInt(BlockData::getOrder));
        this.originalList = this.itemList;
    }

    public void func_231160_c_() {
        if (this.getMinecraft().field_71439_g == null) {
            return;
        }
        this.render = this.field_230707_j_;
        this.field_230710_m_.clear();
        this.scrollList = new ScrollingBlockList(this.getWidth() / 2 - 37, this.getHeight() / 2 + 10, 203, 185, this.itemList, this);
        this.field_230705_e_.add(this.scrollList);
        this.search = new TextFieldWidget(this.getFontRender(), this.getWidth() / 2 - 137, this.getHeight() / 2 - 105, 202, 18, StringTextComponent.field_240750_d_);
        this.search.func_146205_d(true);
        this.func_230480_a_((Widget)new SupportButtonInner(this.getWidth() / 2 + 79, this.getHeight() / 2 - 60, 120, 20, I18n.func_135052_a((String)"xray.input.add", (Object[])new Object[0]), "xray.tooltips.add_block", button -> {
            this.getMinecraft().field_71439_g.func_71053_j();
            this.getMinecraft().func_147108_a((Screen)new GuiBlockList());
        }));
        this.func_230480_a_((Widget)new SupportButtonInner(this.getWidth() / 2 + 79, this.getHeight() / 2 - 38, 120, 20, I18n.func_135052_a((String)"xray.input.add_hand", (Object[])new Object[0]), "xray.tooltips.add_block_in_hand", button -> {
            this.getMinecraft().field_71439_g.func_71053_j();
            ItemStack handItem = this.getMinecraft().field_71439_g.func_184586_b(Hand.MAIN_HAND);
            if (!(handItem.func_77973_b() instanceof BlockItem)) {
                this.getMinecraft().field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("[XRay] " + I18n.func_135052_a((String)"xray.message.invalid_hand", (Object[])new Object[]{handItem.func_200301_q().getString()})), false);
                return;
            }
            this.getMinecraft().func_147108_a((Screen)new GuiAddBlock(((BlockItem)handItem.func_77973_b()).func_179223_d(), GuiSelectionScreen::new));
        }));
        this.func_230480_a_((Widget)new SupportButtonInner(this.getWidth() / 2 + 79, this.getHeight() / 2 - 16, 120, 20, I18n.func_135052_a((String)"xray.input.add_look", (Object[])new Object[0]), "xray.tooltips.add_block_looking_at", button -> {
            ClientPlayerEntity player = this.getMinecraft().field_71439_g;
            if (this.getMinecraft().field_71441_e == null || player == null) {
                return;
            }
            this.func_231175_as__();
            try {
                Vector3d look = player.func_70040_Z();
                Vector3d start = new Vector3d((double)player.func_233580_cy_().func_177958_n(), (double)((float)player.func_233580_cy_().func_177956_o() + player.func_70047_e()), (double)player.func_233580_cy_().func_177952_p());
                Vector3d end = new Vector3d((double)player.func_233580_cy_().func_177958_n() + look.field_72450_a * 100.0, (double)((float)player.func_233580_cy_().func_177956_o() + player.func_70047_e()) + look.field_72448_b * 100.0, (double)player.func_233580_cy_().func_177952_p() + look.field_72449_c * 100.0);
                RayTraceContext context = new RayTraceContext(start, end, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player);
                BlockRayTraceResult result = this.getMinecraft().field_71441_e.func_217299_a(context);
                if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    BlockState state = this.getMinecraft().field_71441_e.func_180495_p(result.func_216350_a());
                    Block lookingAt = this.getMinecraft().field_71441_e.func_180495_p(result.func_216350_a()).func_177230_c();
                    ItemStack lookingStack = lookingAt.getPickBlock(state, (RayTraceResult)result, (IBlockReader)this.getMinecraft().field_71441_e, result.func_216350_a(), (PlayerEntity)this.getMinecraft().field_71439_g);
                    player.func_71053_j();
                    this.getMinecraft().func_147108_a((Screen)new GuiAddBlock(Block.func_149634_a((Item)lookingStack.func_77973_b()), GuiSelectionScreen::new));
                } else {
                    player.func_146105_b((ITextComponent)new StringTextComponent("[XRay] " + I18n.func_135052_a((String)"xray.message.nothing_infront", (Object[])new Object[0])), false);
                }
            }
            catch (NullPointerException ex) {
                player.func_146105_b((ITextComponent)new StringTextComponent("[XRay] " + I18n.func_135052_a((String)"xray.message.thats_odd", (Object[])new Object[0])), false);
            }
        }));
        this.distButtons = new SupportButtonInner(this.getWidth() / 2 + 79, this.getHeight() / 2 + 6, 120, 20, I18n.func_135052_a((String)"xray.input.show-lava", (Object[])new Object[]{Controller.isLavaActive()}), "xray.tooltips.show_lava", button -> {
            Controller.toggleLava();
            button.func_238482_a_((ITextComponent)new TranslationTextComponent("xray.input.show-lava", new Object[]{Controller.isLavaActive()}));
        });
        this.func_230480_a_((Widget)this.distButtons);
        this.distButtons = new SupportButtonInner(this.getWidth() / 2 + 79, this.getHeight() / 2 + 36, 120, 20, I18n.func_135052_a((String)"xray.input.distance", (Object[])new Object[]{Controller.getRadius()}), "xray.tooltips.distance", button -> {
            Controller.incrementCurrentDist();
            button.func_238482_a_((ITextComponent)new TranslationTextComponent("xray.input.distance", new Object[]{Controller.getRadius()}));
        });
        this.func_230480_a_((Widget)this.distButtons);
        this.func_230480_a_((Widget)new Button(this.getWidth() / 2 + 79, this.getHeight() / 2 + 58, 60, 20, (ITextComponent)new TranslationTextComponent("xray.single.help"), button -> {
            this.getMinecraft().field_71439_g.func_71053_j();
            this.getMinecraft().func_147108_a((Screen)new GuiHelp());
        }));
        this.func_230480_a_((Widget)new Button(this.getWidth() / 2 + 79 + 62, this.getHeight() / 2 + 58, 59, 20, (ITextComponent)new TranslationTextComponent("xray.single.close"), button -> this.func_231175_as__()));
    }

    private void updateSearch() {
        if (this.lastSearch.equals(this.search.func_146179_b())) {
            return;
        }
        if (this.search.func_146179_b().equals("")) {
            this.itemList = this.originalList;
            this.scrollList.updateEntries(this.itemList);
            this.lastSearch = "";
            return;
        }
        this.itemList = this.originalList.stream().filter(b -> b.getEntryName().toLowerCase().contains(this.search.func_146179_b().toLowerCase())).collect(Collectors.toCollection(ArrayList::new));
        this.itemList.sort(Comparator.comparingInt(BlockData::getOrder));
        this.scrollList.updateEntries(this.itemList);
        this.lastSearch = this.search.func_146179_b();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.search.func_146178_a();
        this.updateSearch();
    }

    public boolean func_231044_a_(double x, double y, int mouse) {
        if (this.search.func_231044_a_(x, y, mouse)) {
            this.func_231035_a_((IGuiEventListener)this.search);
        }
        if (mouse == 1 && this.distButtons.func_231047_b_(x, y)) {
            Controller.decrementCurrentDist();
            this.distButtons.func_238482_a_((ITextComponent)new TranslationTextComponent("xray.input.distance", new Object[]{Controller.getRadius()}));
            this.distButtons.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
        }
        return super.func_231044_a_(x, y, mouse);
    }

    @Override
    public void renderExtra(MatrixStack stack, int x, int y, float partialTicks) {
        this.search.func_230430_a_(stack, x, y, partialTicks);
        this.scrollList.func_230430_a_(stack, x, y, partialTicks);
        if (!this.search.func_230999_j_() && this.search.func_146179_b().equals("")) {
            XRay.mc.field_71466_p.func_238405_a_(stack, I18n.func_135052_a((String)"xray.single.search", (Object[])new Object[0]), (float)this.getWidth() / 2.0f - 130.0f, (float)this.getHeight() / 2.0f - 101.0f, Color.GRAY.getRGB());
        }
    }

    public void func_231164_f_() {
        Configuration.store.radius.save();
        XRay.blockStore.write(new ArrayList<BlockData>(Controller.getBlockStore().getStore().values()));
        Controller.requestBlockFinder(true);
        super.func_231164_f_();
    }

    static class ScrollingBlockList
    extends ScrollingList<BlockSlot> {
        static final int SLOT_HEIGHT = 35;
        public GuiSelectionScreen parent;

        ScrollingBlockList(int x, int y, int width, int height, List<BlockData> blocks, GuiSelectionScreen parent) {
            super(x, y, width, height, 35);
            this.updateEntries(blocks);
            this.parent = parent;
        }

        public void setSelected(@Nullable BlockSlot entry, int mouse) {
            if (entry == null) {
                return;
            }
            if (GuiSelectionScreen.func_231173_s_()) {
                XRay.mc.field_71439_g.func_71053_j();
                XRay.mc.func_147108_a((Screen)new GuiEdit(entry.block));
                return;
            }
            Controller.getBlockStore().toggleDrawing(entry.block);
            XRay.blockStore.write(new ArrayList<BlockData>(Controller.getBlockStore().getStore().values()));
        }

        void updateEntries(List<BlockData> blocks) {
            this.func_230963_j_();
            blocks.forEach(block -> this.func_230513_b_(new BlockSlot((BlockData)block, this)));
        }

        public static class BlockSlot
        extends AbstractList.AbstractListEntry<BlockSlot> {
            BlockData block;
            ScrollingBlockList parent;

            BlockSlot(BlockData block, ScrollingBlockList parent) {
                this.block = block;
                this.parent = parent;
            }

            public BlockData getBlock() {
                return this.block;
            }

            public void func_230432_a_(MatrixStack stack, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
                BlockData blockData = this.block;
                FontRenderer font = Minecraft.func_71410_x().field_71466_p;
                font.func_238421_b_(stack, blockData.getEntryName(), (float)(left + 40), (float)(top + 7), 0xFFFFFF);
                font.func_238421_b_(stack, blockData.isDrawing() ? "Enabled" : "Disabled", (float)(left + 40), (float)(top + 17), blockData.isDrawing() ? Color.GREEN.getRGB() : Color.RED.getRGB());
                RenderHelper.func_227780_a_();
                Minecraft.func_71410_x().func_175599_af().func_180450_b(blockData.getItemStack(), left + 15, top + 7);
                RenderHelper.func_74518_a();
                if (mouseX > left && mouseX < left + entryWidth && mouseY > top && mouseY < top + entryHeight && mouseY < this.parent.getTop() + this.parent.getHeight() && mouseY > this.parent.getTop()) {
                    this.parent.parent.func_238654_b_(stack, LanguageMap.func_74808_a().func_244260_a(Arrays.asList(new TranslationTextComponent("xray.tooltips.edit1"), new TranslationTextComponent("xray.tooltips.edit2"))), left + 15, entryIdx == this.parent.func_231039_at__().size() - 1 ? top - (entryHeight - 20) : top + (entryHeight + 15));
                }
                RenderSystem.enableAlphaTest();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(CIRCLE);
                GuiBase.drawTexturedQuadFit(left + entryWidth - 37, (float)top + (float)entryHeight / 2.0f - 9.0f, 14.0, 14.0, new int[]{255, 255, 255}, 50.0f);
                GuiBase.drawTexturedQuadFit((double)(left + entryWidth - 35), (double)((float)top + (float)entryHeight / 2.0f - 7.0f), 10.0, 10.0, blockData.getColor());
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
            }

            public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int mouse) {
                this.parent.setSelected(this, mouse);
                return false;
            }
        }
    }

    static final class SupportButtonInner
    extends SupportButton {
        public SupportButtonInner(int widthIn, int heightIn, int width, int height, String text, String i18nKey, Button.IPressable onPress) {
            super(widthIn, heightIn, width, height, (ITextComponent)new StringTextComponent(text), new TranslationTextComponent(i18nKey), onPress);
        }
    }
}

