/*
 * Decompiled with CFR 0.152.
 */
package com.xray.xray;

import com.xray.XRay;
import com.xray.utils.BlockData;
import com.xray.utils.Region;
import com.xray.utils.RenderBlockProps;
import com.xray.xray.Controller;
import com.xray.xray.Render;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import org.apache.commons.lang3.tuple.Pair;

public class RenderEnqueue
implements Runnable {
    private final Region box;

    public RenderEnqueue(Region region) {
        this.box = region;
    }

    @Override
    public void run() {
        this.blockFinder();
    }

    private void blockFinder() {
        HashMap<UUID, BlockData> blocks = Controller.getBlockStore().getStore();
        if (blocks.isEmpty()) {
            if (!Render.syncRenderList.isEmpty()) {
                Render.syncRenderList.clear();
            }
            return;
        }
        ClientWorld world = XRay.mc.field_71441_e;
        ClientPlayerEntity player = XRay.mc.field_71439_g;
        if (world == null || player == null) {
            return;
        }
        ArrayList<RenderBlockProps> renderQueue = new ArrayList<RenderBlockProps>();
        for (int chunkX = this.box.minChunkX; chunkX <= this.box.maxChunkX; ++chunkX) {
            int x = chunkX << 4;
            int lowBoundX = x < this.box.minX ? this.box.minX - x : 0;
            int highBoundX = x + 15 > this.box.maxX ? this.box.maxX - x : 15;
            for (int chunkZ = this.box.minChunkZ; chunkZ <= this.box.maxChunkZ; ++chunkZ) {
                if (!world.func_217354_b(chunkX, chunkZ)) continue;
                Chunk chunk = world.func_212866_a_(chunkX, chunkZ);
                ChunkSection[] extendsList = chunk.func_76587_i();
                int z = chunkZ << 4;
                int lowBoundZ = z < this.box.minZ ? this.box.minZ - z : 0;
                int highBoundZ = z + 15 > this.box.maxZ ? this.box.maxZ - z : 15;
                for (int curExtend = this.box.minChunkY; curExtend <= this.box.maxChunkY; ++curExtend) {
                    ChunkSection ebs = extendsList[curExtend];
                    if (ebs == null) continue;
                    int y = curExtend << 4;
                    int lowBoundY = y < this.box.minY ? this.box.minY - y : 0;
                    int highBoundY = y + 15 > this.box.maxY ? this.box.maxY - y : 15;
                    for (int i = lowBoundX; i <= highBoundX; ++i) {
                        for (int j = lowBoundY; j <= highBoundY; ++j) {
                            for (int k = lowBoundZ; k <= highBoundZ; ++k) {
                                Pair<BlockData, UUID> dataWithUUID;
                                ResourceLocation block;
                                BlockState currentState = ebs.func_177485_a(i, j, k);
                                FluidState currentFluid = currentState.func_204520_s();
                                if ((currentFluid.func_206886_c() == Fluids.field_204547_b || currentFluid.func_206886_c() == Fluids.field_207213_d) && Controller.isLavaActive()) {
                                    renderQueue.add(new RenderBlockProps(x + i, y + j, z + k, 0xFF0000));
                                    continue;
                                }
                                if (Controller.blackList.contains(currentState.func_177230_c()) || (block = currentState.func_177230_c().getRegistryName()) == null || (dataWithUUID = Controller.getBlockStore().getStoreByReference(block.toString())) == null || dataWithUUID.getKey() == null || !((BlockData)dataWithUUID.getKey()).isDrawing()) continue;
                                renderQueue.add(new RenderBlockProps(x + i, y + j, z + k, ((BlockData)dataWithUUID.getKey()).getColor()));
                            }
                        }
                    }
                }
            }
        }
        BlockPos playerPos = player.func_233580_cy_();
        renderQueue.sort((t, t1) -> Double.compare(t1.getPos().func_177951_i((Vector3i)playerPos), t.getPos().func_177951_i((Vector3i)playerPos)));
        Render.syncRenderList.clear();
        Render.syncRenderList.addAll(renderQueue);
    }

    public static void checkBlock(BlockPos pos, BlockState state, boolean add) {
        if (!Controller.isXRayActive() || Controller.getBlockStore().getStore().isEmpty()) {
            return;
        }
        if (!add) {
            Render.syncRenderList.remove(new RenderBlockProps(pos, 0));
            return;
        }
        ResourceLocation block = state.func_177230_c().getRegistryName();
        if (block == null) {
            return;
        }
        Pair<BlockData, UUID> dataWithUUID = Controller.getBlockStore().getStoreByReference(block.toString());
        if (dataWithUUID == null || dataWithUUID.getKey() == null || !((BlockData)dataWithUUID.getKey()).isDrawing()) {
            return;
        }
        Render.syncRenderList.add(new RenderBlockProps(pos, ((BlockData)dataWithUUID.getKey()).getColor()));
    }
}

