/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.filters;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.filters.FilterEntry;
import com.mrcrayfish.filters.Filters;
import com.mrcrayfish.filters.gui.widget.button.IconButton;
import com.mrcrayfish.filters.gui.widget.button.TagButton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class Events {
    private static final ResourceLocation ICONS = new ResourceLocation("filters", "textures/gui/icons.png");
    private static Map<ItemGroup, Integer> scrollMap = new HashMap<ItemGroup, Integer>();
    private boolean updatedFilters;
    private List<TagButton> buttons = new ArrayList<TagButton>();
    private Map<ItemGroup, FilterEntry> miscFilterMap = new HashMap<ItemGroup, FilterEntry>();
    private Button btnScrollUp;
    private Button btnScrollDown;
    private Button btnEnableAll;
    private Button btnDisableAll;
    private boolean viewingFilterTab;
    private int guiCenterX = 0;
    private int guiCenterY = 0;
    private ItemGroup currentGroup = ItemGroup.field_78030_b;

    @SubscribeEvent
    public void onPlayerLogout(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.updatedFilters = false;
    }

    @SubscribeEvent
    public void onScreenInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof CreativeScreen) {
            if (!this.updatedFilters) {
                this.updateFilters();
                this.updatedFilters = true;
            }
            this.viewingFilterTab = false;
            this.guiCenterX = ((CreativeScreen)event.getGui()).getGuiLeft();
            this.guiCenterY = ((CreativeScreen)event.getGui()).getGuiTop();
            this.btnScrollUp = new IconButton(this.guiCenterX - 22, this.guiCenterY - 12, I18n.func_135052_a((String)"gui.button.filters.scroll_filters_up", (Object[])new Object[0]), button -> this.scrollUp(), ICONS, 0, 0);
            event.addWidget((Widget)this.btnScrollUp);
            this.btnScrollDown = new IconButton(this.guiCenterX - 22, this.guiCenterY + 127, I18n.func_135052_a((String)"gui.button.filters.scroll_filters_down", (Object[])new Object[0]), button -> this.scrollDown(), ICONS, 16, 0);
            event.addWidget((Widget)this.btnScrollDown);
            this.btnEnableAll = new IconButton(this.guiCenterX - 50, this.guiCenterY + 10, I18n.func_135052_a((String)"gui.button.filters.enable_filters", (Object[])new Object[0]), button -> this.enableAllFilters(), ICONS, 32, 0);
            event.addWidget((Widget)this.btnEnableAll);
            this.btnDisableAll = new IconButton(this.guiCenterX - 50, this.guiCenterY + 32, I18n.func_135052_a((String)"gui.button.filters.disable_filters", (Object[])new Object[0]), button -> this.disableAllFilters(), ICONS, 48, 0);
            event.addWidget((Widget)this.btnDisableAll);
            this.hideButtons();
            CreativeScreen screen = (CreativeScreen)event.getGui();
            this.updateTagButtons(screen);
            ItemGroup group = this.getGroup(screen.func_147056_g());
            if (Filters.get().hasFilters(group)) {
                this.showButtons();
                this.viewingFilterTab = true;
                this.updateItems(screen);
            }
            this.currentGroup = group;
        }
    }

    @SubscribeEvent
    public void onScreenClick(GuiScreenEvent.MouseClickedEvent.Pre event) {
        if (event.getButton() != 0) {
            return;
        }
        if (event.getGui() instanceof CreativeScreen) {
            for (Button button : this.buttons) {
                if (!button.isMouseOver(event.getMouseX(), event.getMouseY()) || !button.mouseClicked(event.getMouseX(), event.getMouseY(), event.getButton())) continue;
                return;
            }
        }
    }

    public void onCreativeTabChange(CreativeScreen screen, ItemGroup group) {
        if (Filters.get().hasFilters(group) && group != this.currentGroup) {
            this.updateItems(screen);
            this.currentGroup = group;
        }
        this.updateTagButtons(screen);
    }

    @SubscribeEvent
    public void onScreenDrawPre(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (event.getGui() instanceof CreativeScreen) {
            CreativeScreen screen = (CreativeScreen)event.getGui();
            ItemGroup group = this.getGroup(screen.func_147056_g());
            if (Filters.get().hasFilters(group)) {
                if (!this.viewingFilterTab) {
                    this.updateItems(screen);
                    this.viewingFilterTab = true;
                }
            } else {
                this.viewingFilterTab = false;
            }
        }
    }

    @SubscribeEvent
    public void onScreenDrawBackground(GuiContainerEvent.DrawBackground event) {
        if (event.getGuiContainer() instanceof CreativeScreen) {
            CreativeScreen screen = (CreativeScreen)event.getGuiContainer();
            ItemGroup group = this.getGroup(screen.func_147056_g());
            if (Filters.get().hasFilters(group)) {
                this.buttons.forEach(button -> button.render(event.getMouseX(), event.getMouseY(), Minecraft.func_71410_x().func_184121_ak()));
            }
        }
    }

    @SubscribeEvent
    public void onScreenDrawPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof CreativeScreen) {
            CreativeScreen screen = (CreativeScreen)event.getGui();
            ItemGroup group = this.getGroup(screen.func_147056_g());
            if (Filters.get().hasFilters(group)) {
                this.buttons.forEach(button -> {
                    if (button.isMouseOver(event.getMouseX(), event.getMouseY())) {
                        screen.renderTooltip(button.getFilter().getName(), event.getMouseX(), event.getMouseY());
                    }
                });
                if (this.btnEnableAll.isMouseOver((double)event.getMouseX(), (double)event.getMouseY())) {
                    screen.renderTooltip(this.btnEnableAll.getMessage(), event.getMouseX(), event.getMouseY());
                }
                if (this.btnDisableAll.isMouseOver((double)event.getMouseX(), (double)event.getMouseY())) {
                    screen.renderTooltip(this.btnDisableAll.getMessage(), event.getMouseX(), event.getMouseY());
                }
            }
        }
    }

    @SubscribeEvent
    public void onMouseScroll(GuiScreenEvent.MouseScrollEvent.Pre event) {
        if (event.getGui() instanceof CreativeScreen) {
            CreativeScreen creativeScreen = (CreativeScreen)event.getGui();
            int guiLeft = creativeScreen.getGuiLeft();
            int guiTop = creativeScreen.getGuiTop();
            int startX = guiLeft - 32;
            int startY = guiTop + 10;
            int endX = guiLeft;
            int endY = startY + 112 + 3;
            if (event.getMouseX() >= (double)startX && event.getMouseX() < (double)endX && event.getMouseY() >= (double)startY && event.getMouseY() < (double)endY) {
                if (event.getScrollDelta() > 0.0) {
                    this.scrollUp();
                } else {
                    this.scrollDown();
                }
                event.setCanceled(true);
            }
        }
    }

    private void updateTagButtons(CreativeScreen screen) {
        if (!this.updatedFilters) {
            return;
        }
        this.buttons.clear();
        ItemGroup group = this.getGroup(screen.func_147056_g());
        if (Filters.get().hasFilters(group)) {
            int scroll;
            List<FilterEntry> entries = this.getFilters(group);
            for (int i = scroll = scrollMap.computeIfAbsent(group, group1 -> 0).intValue(); i < scroll + 4 && i < entries.size(); ++i) {
                TagButton button = new TagButton(screen.getGuiLeft() - 28, screen.getGuiTop() + 29 * (i - scroll) + 10, entries.get(i), button1 -> this.updateItems(screen));
                this.buttons.add(button);
            }
            this.btnScrollUp.active = scroll > 0;
            this.btnScrollDown.active = scroll <= entries.size() - 4 - 1;
            this.showButtons();
        } else {
            this.hideButtons();
        }
    }

    private void updateItems(CreativeScreen screen) {
        ImmutableList<FilterEntry> entries;
        CreativeScreen.CreativeContainer container = (CreativeScreen.CreativeContainer)screen.func_212873_a_();
        LinkedHashSet<Item> filteredItems = new LinkedHashSet<Item>();
        ItemGroup group = this.getGroup(screen.func_147056_g());
        if (group != null && Filters.get().hasFilters(group) && (entries = Filters.get().getFilters(group)) != null) {
            for (FilterEntry filter : this.getFilters(group)) {
                if (!filter.isEnabled()) continue;
                filteredItems.addAll(filter.getItems());
            }
            container.field_148330_a.clear();
            filteredItems.forEach(item -> item.func_150895_a(group, container.field_148330_a));
            container.field_148330_a.sort(Comparator.comparingInt(o -> Item.func_150891_b((Item)o.func_77973_b())));
            container.func_148329_a(0.0f);
        }
    }

    private void updateFilters() {
        Filters.get().getGroups().forEach(group -> {
            ImmutableList<FilterEntry> entries = Filters.get().getFilters((ItemGroup)group);
            entries.forEach(FilterEntry::clear);
            HashSet removed = new HashSet();
            List<Item> items = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.func_77640_w() == group || item == Items.field_151134_bR).collect(Collectors.toList());
            items.forEach(item -> {
                for (ResourceLocation location : item.getTags()) {
                    for (FilterEntry filter : entries) {
                        if (!location.equals((Object)filter.getTag())) continue;
                        filter.add((Item)item);
                        removed.add(item);
                    }
                }
            });
            items.removeAll(removed);
            if (group.func_111225_m().length == 0) {
                items.remove(Items.field_151134_bR);
            }
            if (!items.isEmpty()) {
                FilterEntry entry = new FilterEntry(new ResourceLocation("miscellaneous"), new ItemStack((IItemProvider)Blocks.field_180401_cv));
                items.forEach(entry::add);
                this.miscFilterMap.put((ItemGroup)group, entry);
            }
        });
    }

    private ItemGroup getGroup(int index) {
        if (index < 0 || index >= ItemGroup.field_78032_a.length) {
            return null;
        }
        return ItemGroup.field_78032_a[index];
    }

    private List<FilterEntry> getFilters(ItemGroup group) {
        if (Filters.get().hasFilters(group)) {
            ArrayList<FilterEntry> filters = new ArrayList<FilterEntry>((Collection<FilterEntry>)Filters.get().getFilters(group));
            if (this.miscFilterMap.containsKey(group)) {
                filters.add(this.miscFilterMap.get(group));
            }
            return filters;
        }
        return Collections.emptyList();
    }

    private void showButtons() {
        this.btnScrollUp.visible = true;
        this.btnScrollDown.visible = true;
        this.btnEnableAll.visible = true;
        this.btnDisableAll.visible = true;
        this.buttons.forEach(button -> {
            button.visible = true;
        });
    }

    private void hideButtons() {
        this.btnScrollUp.visible = false;
        this.btnScrollDown.visible = false;
        this.btnEnableAll.visible = false;
        this.btnDisableAll.visible = false;
        this.buttons.forEach(button -> {
            button.visible = false;
        });
    }

    private void scrollUp() {
        int scroll;
        CreativeScreen creativeScreen;
        ItemGroup group;
        List<FilterEntry> entries;
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof CreativeScreen && (entries = this.getFilters(group = this.getGroup((creativeScreen = (CreativeScreen)screen).func_147056_g()))) != null && (scroll = scrollMap.computeIfAbsent(group, group1 -> 0).intValue()) > 0) {
            scrollMap.put(group, scroll - 1);
            this.updateTagButtons(creativeScreen);
        }
    }

    private void scrollDown() {
        int scroll;
        CreativeScreen creativeScreen;
        ItemGroup group;
        List<FilterEntry> entries;
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof CreativeScreen && (entries = this.getFilters(group = this.getGroup((creativeScreen = (CreativeScreen)screen).func_147056_g()))) != null && (scroll = scrollMap.computeIfAbsent(group, group1 -> 0).intValue()) <= entries.size() - 4 - 1) {
            scrollMap.put(group, scroll + 1);
            this.updateTagButtons(creativeScreen);
        }
    }

    private void enableAllFilters() {
        CreativeScreen creativeScreen;
        ItemGroup group;
        List<FilterEntry> entries;
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof CreativeScreen && (entries = this.getFilters(group = this.getGroup((creativeScreen = (CreativeScreen)screen).func_147056_g()))) != null) {
            entries.forEach(entry -> entry.setEnabled(true));
            this.buttons.forEach(TagButton::updateState);
            this.updateItems(creativeScreen);
        }
    }

    private void disableAllFilters() {
        CreativeScreen creativeScreen;
        ItemGroup group;
        List<FilterEntry> entries;
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof CreativeScreen && (entries = this.getFilters(group = this.getGroup((creativeScreen = (CreativeScreen)screen).func_147056_g()))) != null) {
            entries.forEach(filters -> filters.setEnabled(false));
            this.buttons.forEach(TagButton::updateState);
            this.updateItems(creativeScreen);
        }
    }
}

