/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.filters;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FilterEntry {
    private ResourceLocation tag;
    private String translationKey;
    private ItemStack icon;
    private boolean enabled = true;
    private List<Item> items = new ArrayList<Item>();

    public FilterEntry(ResourceLocation tag, ItemStack icon) {
        this.tag = tag;
        this.translationKey = String.format("gui.tag_filter.%s.%s", tag.func_110624_b(), tag.func_110623_a().replace("/", "."));
        this.icon = icon;
    }

    public ResourceLocation getTag() {
        return this.tag;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public String getName() {
        return I18n.func_135052_a((String)this.translationKey, (Object[])new Object[0]);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    void add(Item item) {
        this.items.add(item);
    }

    void add(Block block) {
        this.items.add(block.func_199767_j());
    }

    void clear() {
        this.items.clear();
    }

    public List<Item> getItems() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterEntry that = (FilterEntry)o;
        return this.tag.equals((Object)that.tag);
    }

    public int hashCode() {
        return this.tag.hashCode();
    }
}

