/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.filters;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mrcrayfish.filters.Events;
import com.mrcrayfish.filters.FilterEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="filters")
public class Filters {
    private static Filters instance;
    private Map<ItemGroup, Set<FilterEntry>> filterMap = new HashMap<ItemGroup, Set<FilterEntry>>();
    public Events events;

    public Filters() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        this.events = new Events();
        MinecraftForge.EVENT_BUS.register((Object)this.events);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        instance = this;
        this.register(ItemGroup.field_78030_b, new ResourceLocation("building_blocks/natural"), new ItemStack((IItemProvider)Blocks.field_196658_i));
        this.register(ItemGroup.field_78030_b, new ResourceLocation("building_blocks/stones"), new ItemStack((IItemProvider)Blocks.field_150348_b));
        this.register(ItemGroup.field_78030_b, new ResourceLocation("building_blocks/woods"), new ItemStack((IItemProvider)Blocks.field_196617_K));
        this.register(ItemGroup.field_78030_b, new ResourceLocation("building_blocks/minerals"), new ItemStack((IItemProvider)Blocks.field_150475_bE));
        this.register(ItemGroup.field_78030_b, new ResourceLocation("stairs"), new ItemStack((IItemProvider)Blocks.field_150476_ad));
        this.register(ItemGroup.field_78030_b, new ResourceLocation("slabs"), new ItemStack((IItemProvider)Blocks.field_196622_bq));
        this.register(ItemGroup.field_78030_b, new ResourceLocation("forge", "glass"), new ItemStack((IItemProvider)Blocks.field_150359_w));
        this.register(ItemGroup.field_78030_b, new ResourceLocation("building_blocks/colored"), new ItemStack((IItemProvider)Blocks.field_196570_aZ));
        this.register(ItemGroup.field_78031_c, new ResourceLocation("decoration_blocks/vegetation"), new ItemStack((IItemProvider)Blocks.field_150349_c));
        this.register(ItemGroup.field_78031_c, new ResourceLocation("decoration_blocks/functional"), new ItemStack((IItemProvider)Blocks.field_150462_ai));
        this.register(ItemGroup.field_78031_c, new ResourceLocation("decoration_blocks/fences_and_walls"), new ItemStack((IItemProvider)Blocks.field_180407_aO));
        this.register(ItemGroup.field_78031_c, new ResourceLocation("decoration_blocks/interior"), new ItemStack((IItemProvider)Blocks.field_196550_aA));
        this.register(ItemGroup.field_78031_c, new ResourceLocation("decoration_blocks/glass"), new ItemStack((IItemProvider)Blocks.field_150410_aZ));
        this.register(ItemGroup.field_78031_c, new ResourceLocation("decoration_blocks/colored"), new ItemStack((IItemProvider)Blocks.field_192440_dO));
        this.register(ItemGroup.field_78031_c, new ResourceLocation("decoration_blocks/special"), new ItemStack((IItemProvider)Blocks.field_196716_eW));
        this.register(ItemGroup.field_78028_d, new ResourceLocation("redstone/core"), new ItemStack((IItemProvider)Items.field_151137_ax));
        this.register(ItemGroup.field_78028_d, new ResourceLocation("redstone/components"), new ItemStack((IItemProvider)Items.field_221670_aw));
        this.register(ItemGroup.field_78028_d, new ResourceLocation("redstone/inputs"), new ItemStack((IItemProvider)Items.field_221737_dE));
        this.register(ItemGroup.field_78028_d, new ResourceLocation("redstone/doors"), new ItemStack((IItemProvider)Items.field_222015_iN));
        this.register(ItemGroup.field_78029_e, new ResourceLocation("transportation/vehicles"), new ItemStack((IItemProvider)Items.field_151143_au));
        this.register(ItemGroup.field_78026_f, new ResourceLocation("miscellaneous/materials"), new ItemStack((IItemProvider)Items.field_151043_k));
        this.register(ItemGroup.field_78026_f, new ResourceLocation("miscellaneous/eggs"), new ItemStack((IItemProvider)Items.field_221943_hD));
        this.register(ItemGroup.field_78026_f, new ResourceLocation("miscellaneous/plants_and_seeds"), new ItemStack((IItemProvider)Items.field_222065_kN));
        this.register(ItemGroup.field_78026_f, new ResourceLocation("miscellaneous/dyes"), new ItemStack((IItemProvider)Items.field_222078_li));
        this.register(ItemGroup.field_78026_f, new ResourceLocation("miscellaneous/discs"), new ItemStack((IItemProvider)Items.field_196166_dX));
        this.register(ItemGroup.field_78039_h, new ResourceLocation("foodstuffs/raw"), new ItemStack((IItemProvider)Items.field_151082_bd));
        this.register(ItemGroup.field_78039_h, new ResourceLocation("foodstuffs/cooked"), new ItemStack((IItemProvider)Items.field_151157_am));
        this.register(ItemGroup.field_78039_h, new ResourceLocation("foodstuffs/special"), new ItemStack((IItemProvider)Items.field_151153_ao));
        this.register(ItemGroup.field_78037_j, new ResourceLocation("combat/armor"), new ItemStack((IItemProvider)Items.field_151030_Z));
        this.register(ItemGroup.field_78037_j, new ResourceLocation("combat/weapons"), new ItemStack((IItemProvider)Items.field_151040_l));
        this.register(ItemGroup.field_78037_j, new ResourceLocation("combat/arrows"), new ItemStack((IItemProvider)Items.field_151032_g));
        this.register(ItemGroup.field_78037_j, new ResourceLocation("combat/enchanting_books"), new ItemStack((IItemProvider)Items.field_151134_bR));
        this.register(ItemGroup.field_78040_i, new ResourceLocation("tools/tools"), new ItemStack((IItemProvider)Items.field_151037_a));
        this.register(ItemGroup.field_78040_i, new ResourceLocation("tools/equipment"), new ItemStack((IItemProvider)Items.field_151111_aL));
        this.register(ItemGroup.field_78040_i, new ResourceLocation("tools/enchanting_books"), new ItemStack((IItemProvider)Items.field_151134_bR));
        this.register(ItemGroup.field_78038_k, new ResourceLocation("brewing/potions"), new ItemStack((IItemProvider)Items.field_185157_bK));
        this.register(ItemGroup.field_78038_k, new ResourceLocation("brewing/ingredients"), new ItemStack((IItemProvider)Items.field_151065_br));
        this.register(ItemGroup.field_78038_k, new ResourceLocation("brewing/equipment"), new ItemStack((IItemProvider)Items.field_222088_mr));
    }

    public static Filters get() {
        return instance;
    }

    public void register(ItemGroup group, @Nullable ResourceLocation tag, ItemStack icon) {
        Set entries = this.filterMap.computeIfAbsent(group, itemGroup -> new LinkedHashSet());
        entries.add(new FilterEntry(tag, icon));
    }

    public Set<ItemGroup> getGroups() {
        return ImmutableSet.copyOf(this.filterMap.keySet());
    }

    public ImmutableList<FilterEntry> getFilters(ItemGroup group) {
        return ImmutableList.copyOf((Collection)this.filterMap.get(group));
    }

    public boolean hasFilters(ItemGroup group) {
        return this.filterMap.containsKey(group);
    }
}

