/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.filters.gui.widget.button;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.filters.FilterEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TagButton
extends Button {
    private static final ResourceLocation TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private FilterEntry category;
    private ItemStack stack;
    private boolean toggled;

    public TagButton(int x, int y, FilterEntry filter, Button.IPressable pressable) {
        super(x, y, 32, 28, "", pressable);
        this.category = filter;
        this.stack = filter.getIcon();
        this.toggled = filter.isEnabled();
    }

    public FilterEntry getFilter() {
        return this.category;
    }

    public void onPress() {
        this.toggled = !this.toggled;
        this.category.setEnabled(this.toggled);
        super.onPress();
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(TABS);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int width = this.toggled ? 32 : 28;
        int textureX = 28;
        int textureY = this.toggled ? 32 : 0;
        this.drawRotatedTexture(this.x, this.y, textureX, textureY, width, 28);
        GlStateManager.enableRescaleNormal();
        RenderHelper.func_74520_c();
        ItemRenderer renderer = mc.func_175599_af();
        renderer.field_77023_b = 100.0f;
        renderer.func_180450_b(this.stack, this.x + 8, this.y + 6);
        renderer.func_175030_a(mc.field_71466_p, this.stack, this.x + 8, this.y + 6);
        renderer.field_77023_b = 100.0f;
    }

    private void drawRotatedTexture(int x, int y, int textureX, int textureY, int width, int height) {
        float scaleX = 0.00390625f;
        float scaleY = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + height) * scaleX), (double)((float)textureY * scaleY)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + height) * scaleX), (double)((float)(textureY + width) * scaleY)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((float)textureX * scaleX), (double)((float)(textureY + width) * scaleY)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)((float)textureX * scaleX), (double)((float)textureY * scaleY)).func_181675_d();
        tessellator.func_78381_a();
    }

    public void updateState() {
        this.toggled = this.category.isEnabled();
    }
}

