/*
 * Decompiled with CFR 0.152.
 */
package io.github.tsudico.disenchanting.common.container;

import com.sun.istack.internal.Nullable;
import java.util.Map;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3914;
import net.minecraft.class_3915;

public class DisenchantTableContainer
extends class_1703 {
    private static final String[] EMPTY_ARMOR_SLOT_IDS = new String[]{"item/empty_armor_slot_boots", "item/empty_armor_slot_leggings", "item/empty_armor_slot_chestplate", "item/empty_armor_slot_helmet"};
    private static final class_1304[] EQUIPMENT_SLOT_ORDER = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    private final class_1263 result;
    private final class_1263 inventoryInput;
    private final class_3914 context;
    private final Random random;
    private final class_3915 levelCost;
    private class_1887 selectedEnchantment;
    private int selectedEnchantmentLevel;
    public final class_1661 playerInventory;

    public DisenchantTableContainer(int syncId, class_1657 player) {
        this(syncId, player.field_7514, class_3914.field_17304);
    }

    public DisenchantTableContainer(int syncId, class_1661 playerInventory, class_3914 blockContext) {
        super(null, syncId);
        int invSlot;
        this.playerInventory = playerInventory;
        this.context = blockContext;
        this.result = new class_1731();
        this.inventoryInput = new class_1277(2){

            public void method_5431() {
                super.method_5431();
                DisenchantTableContainer.this.method_7609((class_1263)this);
            }
        };
        this.random = new Random();
        this.random.setSeed(playerInventory.field_7546.method_5667().getMostSignificantBits());
        this.levelCost = class_3915.method_17403();
        this.method_17362(this.levelCost);
        this.method_7621(new class_1735(this.inventoryInput, 0, 98, 8){

            public boolean method_7680(class_1799 itemStack) {
                return itemStack.method_7942();
            }

            public int method_7675() {
                return 1;
            }

            public class_1799 method_7667(class_1657 playerEntity, class_1799 itemStack) {
                this.field_7871.method_5447(0, class_1799.field_8037);
                DisenchantTableContainer.this.selectedEnchantment = null;
                DisenchantTableContainer.this.updateResult();
                return itemStack;
            }

            public void method_7673(class_1799 itemStack) {
                DisenchantTableContainer.this.selectedEnchantment = null;
                this.field_7871.method_5447(0, itemStack);
                this.method_7668();
            }
        });
        this.method_7621(new class_1735(this.inventoryInput, 1, 98, 44){

            public boolean method_7680(class_1799 itemStack) {
                return itemStack.method_7909() == class_1802.field_8529;
            }

            public class_1799 method_7667(class_1657 playerEntity, class_1799 itemStack) {
                this.field_7871.method_5447(1, class_1799.field_8037);
                DisenchantTableContainer.this.selectedEnchantment = null;
                DisenchantTableContainer.this.updateResult();
                return itemStack;
            }
        });
        this.method_7621(new class_1735(this.result, 2, 152, 26){

            public boolean method_7680(class_1799 itemStack) {
                return false;
            }

            public boolean method_7674(class_1657 playerEntity) {
                return (playerEntity.field_7503.field_7477 || playerEntity.field_7520 >= DisenchantTableContainer.this.levelCost.method_17407()) && DisenchantTableContainer.this.levelCost.method_17407() > 0 && this.method_7681();
            }

            public class_1799 method_7667(class_1657 playerEntity, class_1799 itemStack) {
                class_1799 newBooks;
                if (!playerEntity.field_7503.field_7477) {
                    playerEntity.method_7316(-DisenchantTableContainer.this.levelCost.method_17407());
                }
                if ((newBooks = DisenchantTableContainer.this.inventoryInput.method_5438(1)).method_7947() > 1) {
                    newBooks.method_7939(newBooks.method_7947() - 1);
                    DisenchantTableContainer.this.inventoryInput.method_5447(1, newBooks);
                } else {
                    DisenchantTableContainer.this.inventoryInput.method_5447(1, class_1799.field_8037);
                }
                class_1799 enchantedItem = DisenchantTableContainer.this.inventoryInput.method_5438(0).method_7972();
                Map enchantments = class_1890.method_8222((class_1799)enchantedItem);
                enchantments.remove(DisenchantTableContainer.this.selectedEnchantment);
                enchantedItem.method_7983("Enchantments");
                for (Map.Entry entry : enchantments.entrySet()) {
                    enchantedItem.method_7978((class_1887)entry.getKey(), ((Integer)entry.getValue()).intValue());
                }
                DisenchantTableContainer.this.inventoryInput.method_5447(0, enchantedItem);
                DisenchantTableContainer.this.levelCost.method_17404(0);
                DisenchantTableContainer.this.selectedEnchantment = null;
                return itemStack;
            }
        });
        for (invSlot = 0; invSlot < 9; ++invSlot) {
            this.method_7621(new class_1735((class_1263)playerInventory, invSlot, 8 + invSlot * 18, 142));
        }
        for (invSlot = 0; invSlot < 3; ++invSlot) {
            for (int column = 0; column < 9; ++column) {
                this.method_7621(new class_1735((class_1263)playerInventory, column + invSlot * 9 + 9, 8 + column * 18, 84 + invSlot * 18));
            }
        }
        for (invSlot = 0; invSlot < 4; ++invSlot) {
            final class_1304 equipmentSlot = EQUIPMENT_SLOT_ORDER[invSlot];
            this.method_7621(new class_1735((class_1263)playerInventory, 39 - invSlot, 8, 8 + invSlot * 18){

                public int method_7675() {
                    return 1;
                }

                public boolean method_7680(class_1799 itemStack) {
                    return equipmentSlot == class_1308.method_5953((class_1799)itemStack);
                }

                public boolean method_7674(class_1657 playerEntity) {
                    class_1799 itemStack = this.method_7677();
                    return (itemStack.method_7960() || playerEntity.method_7337() || !class_1890.method_8224((class_1799)itemStack)) && super.method_7674(playerEntity);
                }

                @Nullable
                @Environment(value=EnvType.CLIENT)
                public String method_7679() {
                    return EMPTY_ARMOR_SLOT_IDS[equipmentSlot.method_5927()];
                }
            });
        }
        this.method_7621(new class_1735((class_1263)playerInventory, 40, 26, 62){

            @Nullable
            @Environment(value=EnvType.CLIENT)
            public String method_7679() {
                return "item/empty_armor_slot_shield";
            }
        });
    }

    public void method_7609(class_1263 inventory) {
        super.method_7609(inventory);
        if (this.inventoryInput == inventory) {
            this.random.setSeed(this.random.nextLong());
            this.updateResult();
        }
    }

    private void updateResult() {
        if (this.playerInventory.field_7546.field_6002.field_9236) {
            return;
        }
        class_1799 enchantedItem = this.inventoryInput.method_5438(0);
        class_1799 bookStack = this.inventoryInput.method_5438(1);
        if (enchantedItem.method_7960() || bookStack.method_7960() || !enchantedItem.method_7942()) {
            this.result.method_5447(0, class_1799.field_8037);
            this.levelCost.method_17404(0);
        } else {
            if (null != this.selectedEnchantment) {
                return;
            }
            this.levelCost.method_17404(1);
            class_1799 enchantedItemCopy = enchantedItem.method_7972();
            Map enchantments = class_1890.method_8222((class_1799)enchantedItemCopy);
            if (1 < enchantments.size()) {
                int count = 0;
                if (null == this.selectedEnchantment) {
                    int selected = this.random.nextInt(enchantments.size());
                    for (Map.Entry entry : enchantments.entrySet()) {
                        if (count == selected) {
                            this.selectedEnchantment = (class_1887)entry.getKey();
                            this.selectedEnchantmentLevel = (Integer)entry.getValue();
                            break;
                        }
                        ++count;
                    }
                }
            } else if (enchantments.entrySet().iterator().hasNext()) {
                Map.Entry entry = enchantments.entrySet().iterator().next();
                this.selectedEnchantment = (class_1887)entry.getKey();
                this.selectedEnchantmentLevel = (Integer)entry.getValue();
            } else {
                this.selectedEnchantment = null;
            }
            if (null != this.selectedEnchantment) {
                int weight = this.selectedEnchantment.method_8186().method_8197();
                int enchantLevel = this.selectedEnchantmentLevel;
                float cost = (float)(enchantLevel * 5) * (1.6f - (float)weight * 0.03f);
                this.levelCost.method_17404(Math.round(cost));
                class_1799 enchantedBook = class_1772.method_7808((class_1889)new class_1889(this.selectedEnchantment, this.selectedEnchantmentLevel));
                this.result.method_5447(0, enchantedBook);
            } else {
                this.result.method_5447(0, class_1799.field_8037);
                this.levelCost.method_17404(0);
            }
        }
        this.method_7623();
    }

    public class_1799 method_7601(class_1657 playerEntity, int slot) {
        class_1799 newSlotStack = class_1799.field_8037;
        class_1735 oldSlot = (class_1735)this.field_7761.get(slot);
        if (oldSlot != null && oldSlot.method_7681()) {
            class_1799 oldSlotStack = oldSlot.method_7677();
            newSlotStack = oldSlotStack.method_7972();
            if (slot == 2) {
                if (!this.method_7616(oldSlotStack, 3, 39, true)) {
                    return class_1799.field_8037;
                }
                oldSlot.method_7670(oldSlotStack, newSlotStack);
            } else if (slot != 0 && slot != 1) {
                if (slot < 39 && !this.method_7616(oldSlotStack, 0, 2, false)) {
                    return class_1799.field_8037;
                }
                oldSlot.method_7670(oldSlotStack, newSlotStack);
            } else if (!this.method_7616(oldSlotStack, 3, 39, false)) {
                return class_1799.field_8037;
            }
            if (oldSlotStack.method_7960()) {
                oldSlot.method_7673(class_1799.field_8037);
            } else {
                oldSlot.method_7668();
            }
            if (oldSlotStack.method_7947() == newSlotStack.method_7947()) {
                return class_1799.field_8037;
            }
            oldSlot.method_7667(playerEntity, oldSlotStack);
        }
        this.updateResult();
        return newSlotStack;
    }

    public void method_7595(class_1657 playerEntity) {
        super.method_7595(playerEntity);
        for (int i = 0; i < this.inventoryInput.method_5439(); ++i) {
            playerEntity.method_7328(this.inventoryInput.method_5438(i), false);
            this.inventoryInput.method_5441(i);
        }
    }

    public boolean method_7597(class_1657 playerEntity) {
        return DisenchantTableContainer.method_17695((class_3914)this.context, (class_1657)playerEntity, (class_2248)class_2246.field_10485);
    }

    @Environment(value=EnvType.CLIENT)
    public int getLevelCost() {
        return this.levelCost.method_17407();
    }
}

