/*
 * Decompiled with CFR 0.152.
 */
package rouletteores.handlers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;
import rouletteores.JsonHelper;
import rouletteores.client.UpdateNotification;
import rouletteores.core.RO_Settings;
import rouletteores.core.RouletteOres;
import rouletteores.scheduler.RouletteRewardRegistry;

public class ConfigHandler {
    public static Configuration config;
    static JsonArray defComs;

    public static void initConfigs() {
        boolean flag;
        File fileEvents;
        block8: {
            JsonArray ja;
            if (config == null) {
                RouletteOres.logger.log(Level.ERROR, "Config attempted to be loaded before it was initialised!");
                return;
            }
            fileEvents = new File("config/RouletteEvents.json");
            File fileDefaults = new File("config/RouletteDefaults.json");
            flag = false;
            if (!fileEvents.exists()) {
                flag = true;
            }
            RouletteRewardRegistry.loadRewards(JsonHelper.ReadArrayFromFile(fileEvents), false);
            config.load();
            RO_Settings.hideUpdates = config.getBoolean("Hide Updates", "general", false, "Hides the update notifications");
            RO_Settings.useOnline = config.getBoolean("Use Online Defaults", "general", true, "Use Funwayguy's pick of events (Must be connected to the internet)");
            RO_Settings.nonDropSelf = config.getBoolean("Non-self Ore Drops", "general", true, "Check whether the ore drop is itself or not. Prevent's exploits on ores like iron");
            RO_Settings.chance = config.getFloat("Roulette Chance", "general", 0.01f, 0.0f, 1.0f, "Chance a random command will be run");
            RO_Settings.fakePlayers = config.getBoolean("Enable Fake Players", "general", false, "Enable machines acting as player to trigger RouletteOres");
            RO_Settings.silkImmunity = config.getBoolean("Silk Immunity", "general", true, "Using silk touch on ores prevents triggering events");
            RO_Settings.fortuneMult = config.getBoolean("Fortune Multiplier", "general", true, "Fortune enchantments multiply the chance of triggering an ore");
            RO_Settings.genRoulette = config.getBoolean("Generate Ores", "general", true, "Generate the mod's native Roulette Ore");
            RO_Settings.orePerChunk = config.getInt("Ores Per Chunk", "general", 4, 0, Integer.MAX_VALUE, "Determines how many Roulette Ores generates within each chunk");
            RO_Settings.extraOres.clear();
            RO_Settings.extraOres.addAll(Arrays.asList(config.getStringList("Extra Ores", "general", new String[0], "Additional blocks that should be treated as 'ores' (Ignores non-self drops)")));
            if (config.hasKey("general", "Roulette Commands")) {
                RouletteOres.logger.log(Level.WARN, "Converting legacy commands... (NOT EVERYTHING WILL WORK)");
                String[] oldCmds = config.getStringList("Roulette Commands", "general", new String[0], "List of possible commands (Turn off online defaults if editing)(use ';;' to split multiple commands)");
                config.getCategory("general").remove((Object)"Roulette Commands");
                for (String cmd : oldCmds) {
                    RouletteRewardRegistry.readLegacyReward(cmd);
                }
                ja = new JsonArray();
                RouletteRewardRegistry.saveRewards(ja);
                JsonHelper.WriteToFile(fileEvents, (JsonElement)ja);
                flag = false;
            }
            if (RO_Settings.useOnline) {
                try {
                    String onlineList = UpdateNotification.getNotification("https://raw.githubusercontent.com/Funwayguy/RouletteOre-Defaults/master/AdvancedCommands1.9.json", false);
                    Gson g = new GsonBuilder().setPrettyPrinting().create();
                    JsonArray ja2 = (JsonArray)g.fromJson(onlineList, JsonArray.class);
                    RouletteRewardRegistry.loadRewards(ja2, true);
                    JsonHelper.WriteToFile(fileDefaults, (JsonElement)ja2);
                    flag = false;
                    RouletteOres.logger.log(Level.INFO, "Loaded online default commands and updated RouletteDefault.json");
                }
                catch (Exception e) {
                    if (!fileDefaults.exists()) break block8;
                    RouletteOres.logger.log(Level.WARN, "Unable to load online defaults, loading cached version...", (Throwable)e);
                    ja = JsonHelper.ReadArrayFromFile(fileDefaults);
                    RouletteRewardRegistry.loadRewards(ja, true);
                    flag = false;
                }
            }
        }
        if (flag) {
            RouletteRewardRegistry.loadRewards(defComs, true);
            JsonHelper.WriteToFile(fileEvents, (JsonElement)defComs);
            flag = false;
            RouletteOres.logger.log(Level.INFO, "Loaded local default commands and updated RouletteEvents.json");
        }
        config.save();
        RouletteOres.logger.log(Level.INFO, "Configs loaded.");
    }

    static {
        defComs = new JsonArray();
        try {
            InputStreamReader isr = new InputStreamReader(ConfigHandler.class.getResourceAsStream("/defaults.json"));
            defComs = (JsonArray)new Gson().fromJson((Reader)isr, JsonArray.class);
            isr.close();
        }
        catch (Exception e) {
            RouletteOres.logger.log(Level.ERROR, "Unable to load local defaults!", (Throwable)e);
            defComs = new JsonArray();
        }
    }
}

