/*
 * Decompiled with CFR 0.152.
 */
package rouletteores.scheduler;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import rouletteores.JsonHelper;

public class RouletteReward {
    protected String name = "New Reward";
    protected HashMap<Integer, ArrayList<String>> schedule = new HashMap();
    protected ArrayList<String> mods = new ArrayList();

    public String getName() {
        return this.name;
    }

    public ArrayList<String> getCommandsAtTime(int tickTime) {
        return this.schedule.get(tickTime);
    }

    public int getDuration() {
        int n = 0;
        for (Integer i : this.schedule.keySet()) {
            n = Math.max(i, n);
        }
        return n;
    }

    public void readFromJson(JsonObject json) {
        this.name = JsonHelper.GetString(json, "name", "New Reward");
        this.schedule.clear();
        for (JsonElement entry : JsonHelper.GetArray(json, "events")) {
            if (entry == null || !entry.isJsonObject()) continue;
            JsonObject j = entry.getAsJsonObject();
            int time = JsonHelper.GetNumber(j, "delay", 0).intValue();
            String cmd = JsonHelper.GetString(j, "command", "");
            if (this.schedule.containsKey(time)) {
                this.schedule.get(time).add(cmd);
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(cmd);
            this.schedule.put(time, list);
        }
        this.mods.clear();
        for (JsonElement entry : JsonHelper.GetArray(json, "req_mods")) {
            if (entry == null || !entry.isJsonPrimitive() || !entry.getAsJsonPrimitive().isString()) continue;
            this.mods.add(entry.getAsString());
        }
    }

    public void writeToJson(JsonObject json) {
        json.addProperty("name", this.name);
        JsonArray reqMods = new JsonArray();
        for (String s : this.mods) {
            reqMods.add((JsonElement)new JsonPrimitive(s));
        }
        json.add("req_mods", (JsonElement)reqMods);
        JsonArray jRewards = new JsonArray();
        for (Map.Entry<Integer, ArrayList<String>> entry : this.schedule.entrySet()) {
            for (String c : entry.getValue()) {
                JsonObject jRwd = new JsonObject();
                jRwd.addProperty("delay", (Number)entry.getKey());
                jRwd.addProperty("command", c);
                jRewards.add((JsonElement)jRwd);
            }
        }
        json.add("events", (JsonElement)jRewards);
    }
}

