/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.forge;

import CoroUtil.config.ConfigCoroAI;
import CoroUtil.config.ConfigDynamicDifficulty;
import CoroUtil.diplomacy.TeamTypes;
import CoroUtil.forge.CommandCoroUtil;
import CoroUtil.forge.CommonProxy;
import CoroUtil.forge.EventHandlerFML;
import CoroUtil.forge.EventHandlerForge;
import CoroUtil.forge.EventHandlerPacket;
import CoroUtil.pets.PetsManager;
import CoroUtil.quest.PlayerQuestManager;
import CoroUtil.util.CoroUtilFile;
import CoroUtil.world.WorldDirectorManager;
import com.google.common.collect.BiMap;
import modconfig.ConfigMod;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@Mod(modid="coroutil", name="coroutil", version="1.11.2-1.1.19", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.11.2]")
public class CoroUtil {
    @Mod.Instance(value="coroutil")
    public static CoroUtil instance;
    public static String modID;
    public static final String version = "1.11.2-1.1.19";
    @SidedProxy(clientSide="CoroUtil.forge.ClientProxy", serverSide="CoroUtil.forge.CommonProxy")
    public static CommonProxy proxy;
    public static boolean initProperNeededForInstance;
    public static String eventChannelName;
    public static final FMLEventChannel eventChannel;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigMod.addConfigFile(event, new ConfigCoroAI());
        ConfigMod.addConfigFile(event, new ConfigDynamicDifficulty());
        eventChannel.register((Object)new EventHandlerPacket());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerFML());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerForge());
        proxy.init(this);
        TeamTypes.initTypes();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        boolean debugOutputEntityRegistrations = false;
        if (debugOutputEntityRegistrations) {
            try {
                BiMap entityClassRegistrations = (BiMap)ObfuscationReflectionHelper.getPrivateValue(EntityRegistry.class, (Object)EntityRegistry.instance(), (String[])new String[]{"entityClassRegistrations"});
                for (EntityRegistry.EntityRegistration entityRegistration : entityClassRegistrations.values()) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandCoroUtil());
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        CoroUtil.writeOutData(true);
        initProperNeededForInstance = true;
    }

    public static void initTry() {
        if (initProperNeededForInstance) {
            System.out.println("CoroUtil being reinitialized");
            initProperNeededForInstance = false;
            CoroUtilFile.getWorldFolderName();
            PetsManager.instance().nbtReadFromDisk();
            WorldDirectorManager.instance().reset();
        }
    }

    public static void writeOutData(boolean unloadInstances) {
        try {
            PetsManager.instance().nbtWriteToDisk();
            if (unloadInstances) {
                PetsManager.instance().reset();
            }
            PlayerQuestManager.i().saveData(false, unloadInstances);
            WorldDirectorManager.instance().writeToFile(unloadInstances);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void dbg(Object obj) {
        System.out.println(obj);
    }

    static {
        modID = "coroutil";
        initProperNeededForInstance = true;
        eventChannelName = "coroutil";
        eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(eventChannelName);
    }
}

