/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.forge;

import CoroUtil.config.ConfigCoroAI;
import CoroUtil.forge.CoroUtil;
import CoroUtil.quest.PlayerQuestManager;
import CoroUtil.test.Headshots;
import CoroUtil.util.CoroUtilPlayer;
import CoroUtil.util.Vec3;
import CoroUtil.world.WorldDirector;
import CoroUtil.world.WorldDirectorManager;
import CoroUtil.world.grid.block.BlockDataPoint;
import CoroUtil.world.grid.chunk.ChunkDataPoint;
import CoroUtil.world.player.DynamicDifficulty;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class EventHandlerForge {
    @SubscribeEvent
    public void deathEvent(LivingDeathEvent event) {
        PlayerQuestManager.i().onEvent((Event)event);
    }

    @SubscribeEvent
    public void pickupEvent(EntityItemPickupEvent event) {
        PlayerQuestManager.i().onEvent((Event)event);
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && ((WorldServer)event.getWorld()).field_73011_w.getDimension() == 0) {
            CoroUtil.writeOutData(false);
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && ((WorldServer)event.getWorld()).field_73011_w.getDimension() == 0 && WorldDirectorManager.instance().getWorldDirector(CoroUtil.modID, event.getWorld()) == null) {
            WorldDirectorManager.instance().registerWorldDirector(new WorldDirector(true), CoroUtil.modID, event.getWorld());
        }
    }

    @SubscribeEvent
    public void breakBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        PlayerQuestManager.i().onEvent((Event)event);
        DynamicDifficulty.handleHarvest(event);
    }

    @SubscribeEvent
    public void breakBlockPlayer(BlockEvent.BreakEvent event) {
        PlayerQuestManager.i().onEvent((Event)event);
    }

    @SubscribeEvent
    public void blockPlayerInteract(PlayerInteractEvent event) {
        if (!event.getWorld().field_72995_K) {
            try {
                if (event instanceof PlayerInteractEvent.RightClickEmpty) {
                    return;
                }
                if (ConfigCoroAI.trackPlayerData) {
                    ChunkDataPoint cdp = WorldDirectorManager.instance().getChunkDataGrid(event.getWorld()).getChunkData(event.getPos().func_177958_n() / 16, event.getPos().func_177952_p() / 16);
                    cdp.addToPlayerActivityInteract(event.getEntityPlayer().func_146103_bH().getId(), 1L);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void entityHurt(LivingHurtEvent event) {
        Headshots.hookLivingHurt(event);
        DynamicDifficulty.logDamage(event);
    }

    @SubscribeEvent
    public void entityKilled(LivingDeathEvent event) {
        DynamicDifficulty.logDeath(event);
    }

    @SubscribeEvent
    public void entityTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase ent = event.getEntityLiving();
        if (!ent.field_70170_p.field_72995_K && ent instanceof EntityPlayer) {
            CoroUtilPlayer.trackPlayerForSpeed((EntityPlayer)ent);
        }
        if (ConfigCoroAI.desirePathDerp) {
            int walkOnRate = 5;
            if (!ent.field_70170_p.field_72995_K && ent.field_70170_p.func_82737_E() % (long)walkOnRate == 0L) {
                int newZ;
                int newY;
                int newX;
                IBlockState state;
                Block id;
                double speed = Math.sqrt(ent.field_70159_w * ent.field_70159_w + ent.field_70181_x * ent.field_70181_x + ent.field_70179_y * ent.field_70179_y);
                if (ent instanceof EntityPlayer) {
                    Vec3 vec = CoroUtilPlayer.getPlayerSpeedCapped((EntityPlayer)ent, 0.1f);
                    speed = Math.sqrt(vec.xCoord * vec.xCoord + vec.yCoord * vec.yCoord + vec.zCoord * vec.zCoord);
                }
                if (speed > 0.08 && (id = (state = ent.field_70170_p.func_180495_p(new BlockPos(newX = MathHelper.func_76128_c((double)ent.field_70165_t), newY = MathHelper.func_76128_c((double)(ent.func_174813_aQ().field_72338_b - 1.0)), newZ = MathHelper.func_76128_c((double)ent.field_70161_v)))).func_177230_c()) == Blocks.field_150349_c) {
                    BlockDataPoint bdp = WorldDirectorManager.instance().getBlockDataGrid(ent.field_70170_p).getBlockData(newX, newY, newZ);
                    bdp.walkedOnAmount += 0.25f;
                    if (bdp.walkedOnAmount > 5.0f) {
                        if (ent.field_70170_p.func_180495_p(new BlockPos(newX, newY + 1, newZ)).func_177230_c() == Blocks.field_150350_a) {
                            ent.field_70170_p.func_175656_a(new BlockPos(newX, newY, newZ), Blocks.field_185774_da.func_176223_P());
                        }
                        WorldDirectorManager.instance().getBlockDataGrid(ent.field_70170_p).removeBlockData(newX, newY, newZ);
                    }
                }
            }
        }
    }
}

