/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.quest;

import CoroUtil.forge.CoroUtil;
import CoroUtil.packet.PacketHelper;
import CoroUtil.quest.EnumQuestState;
import CoroUtil.quest.PlayerQuestManager;
import CoroUtil.quest.quests.ActiveQuest;
import CoroUtil.util.CoroUtilFile;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerQuests {
    public PlayerQuestManager playerQuestMan;
    public String playerName = "Player";
    public List<ActiveQuest> activeQuests;

    public PlayerQuests(PlayerQuestManager parMan, String parName) {
        this.playerQuestMan = parMan;
        this.playerName = parName;
        this.activeQuests = new ArrayList<ActiveQuest>();
    }

    public static ActiveQuest createQuestFromString(String parFullClassName) {
        try {
            Class<?> createClass = Class.forName(parFullClassName);
            Constructor<?> constructor = createClass.getConstructor(new Class[0]);
            Object createObject = constructor.newInstance(new Object[0]);
            if (createObject instanceof ActiveQuest) {
                return (ActiveQuest)createObject;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public World getWorld() {
        return this.getPlayer().field_70170_p;
    }

    public EntityPlayer getPlayer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(this.playerName);
    }

    public void tick(World parWorld) {
        for (int i = 0; i < this.activeQuests.size(); ++i) {
            this.activeQuests.get(i).tick();
            if (!this.activeQuests.get(i).isComplete()) continue;
            this.onComplete(parWorld, i, true);
        }
    }

    public void saveAndSyncAllPlayers() {
        this.saveAndSyncPlayer();
    }

    public void saveAndSyncPlayer() {
        this.sync();
        this.diskSaveToFile();
    }

    public void sync() {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            try {
                NBTTagCompound data = new NBTTagCompound();
                this.nbtSave(data);
                nbt.func_74778_a("command", "QuestData");
                nbt.func_74782_a("data", (NBTBase)data);
                FMLProxyPacket packet = PacketHelper.getNBTPacket(nbt, CoroUtil.eventChannelName);
                CoroUtil.eventChannel.sendTo(packet, (EntityPlayerMP)this.getPlayer());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected static void writeNBTTagCompound(NBTTagCompound par0NBTTagCompound, DataOutputStream par1DataOutputStream, byte[] data) throws IOException {
        if (par0NBTTagCompound == null) {
            par1DataOutputStream.writeShort(-1);
        } else {
            par1DataOutputStream.writeShort((short)data.length);
            par1DataOutputStream.write(data);
        }
    }

    public void onComplete(World parWorld, int questIndex, boolean completeForAllInWorld) {
        if (completeForAllInWorld) {
            this.playerQuestMan.markQuestCompleteForAll(parWorld, this.activeQuests.get(questIndex));
        } else {
            this.questRemove(this.activeQuests.get(questIndex));
        }
        this.sync();
    }

    public ActiveQuest getFirstQuestByStatus(EnumQuestState questState) {
        for (int i = 0; i < this.activeQuests.size(); ++i) {
            if (this.activeQuests.get((int)i).curState != questState) continue;
            return this.activeQuests.get(i);
        }
        return null;
    }

    public void questAdd(ActiveQuest quest) {
        this.activeQuests.add(quest);
    }

    public void questRemove(ActiveQuest quest) {
        for (int i = 0; i < this.activeQuests.size(); ++i) {
            if (this.activeQuests.get(i) != quest) continue;
            this.activeQuests.get(i).reset();
            this.activeQuests.remove(i);
        }
    }

    public void questsClearAll() {
        for (int i = 0; i < this.activeQuests.size(); ++i) {
            this.activeQuests.get(i).reset();
        }
        this.activeQuests.clear();
    }

    public void onEvent(Event event) {
        for (int i = 0; i < this.activeQuests.size(); ++i) {
            this.activeQuests.get(i).onEvent(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderQuestOverlay() {
        int startX = 10;
        int startY = 10;
        Minecraft mc = FMLClientHandler.instance().getClient();
        mc.field_71466_p.func_175063_a("Quests:", (float)startX, (float)startY, 0xFFFFFF);
        startY += 20;
        int questSpacing = 40;
        int infoSpacing = 10;
        for (int i = 0; i < this.activeQuests.size(); ++i) {
            ActiveQuest quest = this.activeQuests.get(i);
            String qStr = "";
            String qStr2 = "";
            String qStr3 = "";
            qStr = quest.getTitle();
            mc.field_71466_p.func_175063_a(ChatFormatting.BLUE + qStr, (float)startX, (float)(startY + i * questSpacing), 0xFFFFFF);
            mc.field_71466_p.func_175063_a(qStr2, (float)startX, (float)(startY + infoSpacing + i * questSpacing), 0xFFFFFF);
            mc.field_71466_p.func_175063_a(qStr3, (float)startX, (float)(startY + infoSpacing * 2 + i * questSpacing), 0xFFFFFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diskLoadFromFile() {
        FileInputStream fis = null;
        try {
            String URL2 = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "CoroUtil" + File.separator + "Quests" + File.separator;
            File file = new File(URL2 + this.playerName + ".dat");
            if (file.exists()) {
                fis = new FileInputStream(file);
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fis);
                this.nbtLoad(nbttagcompound);
                if (fis != null) {
                    fis.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void diskSaveToFile() {
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            this.nbtSave(nbt);
            String URL2 = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName() + "CoroUtil" + File.separator + "Quests" + File.separator;
            File fl = new File(URL2);
            if (!fl.exists()) {
                fl.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(URL2 + this.playerName + ".dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void syncUpdateQuests(NBTTagCompound parNBT) {
    }

    public void nbtLoad(NBTTagCompound parNBT) {
        if (!parNBT.func_82582_d()) {
            for (String tagName : parNBT.func_150296_c()) {
                NBTTagCompound data = parNBT.func_74775_l(tagName);
                String classNamePath = data.func_74779_i("classNamePath");
                ActiveQuest quest = PlayerQuests.createQuestFromString(classNamePath);
                if (quest != null) {
                    quest.initCreateObject(this);
                    quest.load(data);
                    quest.initCreateLoad();
                    this.questAdd(quest);
                    continue;
                }
                System.out.println("CoroUtil was unable to deserialize quest with classname path: " + classNamePath + ", this might be due to a code structure change or a bug, quest not readded");
            }
        }
    }

    public void nbtSave(NBTTagCompound parNBT) {
        for (int i = 0; i < this.activeQuests.size(); ++i) {
            NBTTagCompound questNBT = new NBTTagCompound();
            this.activeQuests.get(i).save(questNBT);
            parNBT.func_74782_a("qIndex" + i, (NBTBase)questNBT);
        }
    }

    public void reset() {
        this.questsClearAll();
    }
}

